<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rutina de Entrenamiento - {{ $client->name }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '{{ $settings["primary_color"] ?? "#3b82f6" }}',
                        secondary: '{{ $settings["secondary_color"] ?? "#f97316" }}',
                        accent: '{{ $settings["accent_color"] ?? "#10b981" }}',
                    }
                }
            }
        }
    </script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap');
        
        * {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        }
        
        @page {
            size: A4;
            margin: 0;
        }
        
        body {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }
        
        .page-break {
            page-break-after: always;
        }
        
        .avoid-break {
            page-break-inside: avoid;
        }
        
        .gradient-primary {
            background: linear-gradient(135deg, {{ $settings['primary_color'] ?? '#3b82f6' }}, {{ $settings['secondary_color'] ?? '#f97316' }});
        }
        
        .gradient-secondary {
            background: linear-gradient(135deg, {{ $settings['secondary_color'] ?? '#f97316' }}, #ea580c);
        }
        
        .exercise-card {
            transition: all 0.2s;
        }
        
        .exercise-number {
            background: linear-gradient(135deg, {{ $settings['secondary_color'] ?? '#f97316' }}, {{ $settings['primary_color'] ?? '#3b82f6' }});
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Header -->
    <div class="gradient-primary text-white px-8 py-6">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-4">
                @if(isset($settings['logo']) && $settings['logo'])
                    <img src="{{ asset('storage/' . $settings['logo']) }}" alt="Logo" class="h-12 rounded-lg bg-white/20 p-1">
                @endif
                <div>
                    <h1 class="text-2xl font-bold">{{ $settings['site_name'] ?? 'CoachPro' }}</h1>
                    <p class="text-white/80 text-sm">Rutina de Entrenamiento Personalizada</p>
                </div>
            </div>
            <div class="text-right">
                <p class="text-white/80 text-sm">Fecha de emisión</p>
                <p class="font-semibold">{{ now()->format('d/m/Y') }}</p>
            </div>
        </div>
    </div>

    <div class="px-8 py-6">
        <!-- Client & Workout Info -->
        <div class="grid grid-cols-2 gap-4 mb-6">
            <!-- Client Card -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-5">
                <div class="flex items-center gap-4">
                    <div class="w-14 h-14 rounded-full gradient-secondary flex items-center justify-center text-white text-xl font-bold">
                        {{ strtoupper(substr($client->name, 0, 1)) }}
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Cliente</p>
                        <h2 class="text-lg font-bold text-gray-900">{{ $client->name }}</h2>
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-700 mt-1">
                            ✓ Activo
                        </span>
                    </div>
                </div>
            </div>

            <!-- Workout Card -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-5">
                <div class="flex items-center gap-4">
                    <div class="w-14 h-14 rounded-xl bg-blue-100 flex items-center justify-center">
                        <span class="text-3xl">💪</span>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Rutina</p>
                        <h2 class="text-lg font-bold text-gray-900">{{ $workout->name }}</h2>
                        @if($workout->difficulty)
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium 
                                @if($workout->difficulty === 'beginner') bg-green-100 text-green-700
                                @elseif($workout->difficulty === 'intermediate') bg-yellow-100 text-yellow-700
                                @else bg-red-100 text-red-700
                                @endif mt-1">
                                {{ $workout->difficulty === 'beginner' ? '🌱 Principiante' : ($workout->difficulty === 'intermediate' ? '⚡ Intermedio' : '🔥 Avanzado') }}
                            </span>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Stats Row -->
        <div class="grid grid-cols-4 gap-4 mb-6">
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4 text-center">
                <div class="text-3xl mb-2">🎯</div>
                <p class="text-2xl font-bold text-gray-900">{{ $exercises->count() }}</p>
                <p class="text-xs text-gray-500 uppercase tracking-wide">Ejercicios</p>
            </div>
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4 text-center">
                <div class="text-3xl mb-2">📅</div>
                <p class="text-2xl font-bold text-gray-900">{{ count($days) }}</p>
                <p class="text-xs text-gray-500 uppercase tracking-wide">Días/Semana</p>
            </div>
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4 text-center">
                <div class="text-3xl mb-2">⏱️</div>
                <p class="text-2xl font-bold text-gray-900">{{ $workout->duration ?? '45' }}</p>
                <p class="text-xs text-gray-500 uppercase tracking-wide">Min. Aprox.</p>
            </div>
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4 text-center">
                <div class="text-3xl mb-2">🔄</div>
                <p class="text-2xl font-bold text-gray-900">{{ $exercises->sum('sets') }}</p>
                <p class="text-xs text-gray-500 uppercase tracking-wide">Series Total</p>
            </div>
        </div>

        <!-- Training Days -->
        @if(count($days) > 0)
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4 mb-6">
                <h3 class="font-semibold text-gray-700 mb-3 text-sm">📅 Días de Entrenamiento</h3>
                <div class="flex flex-wrap gap-2">
                    @foreach($days as $day)
                        <span class="inline-flex items-center px-4 py-2 rounded-lg text-sm font-medium gradient-primary text-white">
                            {{ $day }}
                        </span>
                    @endforeach
                </div>
            </div>
        @endif

        <!-- Exercises List -->
        <div class="space-y-4">
            @foreach($exercises as $index => $exercise)
                <div class="avoid-break bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden exercise-card">
                    <div class="flex">
                        <!-- Exercise Number -->
                        <div class="exercise-number w-16 flex items-center justify-center text-white">
                            <span class="text-2xl font-bold">{{ $index + 1 }}</span>
                        </div>
                        
                        <!-- Exercise Content -->
                        <div class="flex-1 p-4">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <h3 class="font-bold text-gray-900 text-lg">{{ $exercise->name }}</h3>
                                    <div class="flex flex-wrap items-center gap-2 mt-1">
                                        @if($exercise->muscle_group)
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-purple-100 text-purple-700">
                                                🎯 {{ $exercise->muscle_group }}
                                            </span>
                                        @endif
                                        @if($exercise->equipment)
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-700">
                                                🏋️ {{ $exercise->equipment }}
                                            </span>
                                        @endif
                                    </div>
                                </div>
                                
                                <!-- Sets x Reps Badge -->
                                <div class="gradient-primary text-white px-5 py-2 rounded-xl text-center shadow-lg">
                                    <p class="text-xl font-bold">{{ $exercise->sets }} x {{ $exercise->reps }}</p>
                                    <p class="text-xs text-white/80">series × reps</p>
                                </div>
                            </div>
                            
                            <!-- Exercise Details Grid -->
                            <div class="grid grid-cols-3 gap-4 mt-4">
                                @if($exercise->weight)
                                    <div class="bg-gray-50 rounded-lg p-3 text-center">
                                        <p class="text-xs text-gray-500 mb-1">Peso</p>
                                        <p class="font-bold text-gray-900">{{ $exercise->weight }} kg</p>
                                    </div>
                                @endif
                                @if($exercise->rest_seconds)
                                    <div class="bg-green-50 rounded-lg p-3 text-center">
                                        <p class="text-xs text-gray-500 mb-1">Descanso</p>
                                        <p class="font-bold text-green-700">{{ $exercise->rest_seconds }}s</p>
                                    </div>
                                @endif
                                @if($exercise->tempo)
                                    <div class="bg-blue-50 rounded-lg p-3 text-center">
                                        <p class="text-xs text-gray-500 mb-1">Tempo</p>
                                        <p class="font-bold text-blue-700">{{ $exercise->tempo }}</p>
                                    </div>
                                @endif
                            </div>
                            
                            @if($exercise->notes)
                                <div class="mt-3 bg-amber-50 border border-amber-200 rounded-lg p-3">
                                    <p class="text-sm text-amber-800">
                                        <span class="font-semibold">💡 Nota:</span> {{ $exercise->notes }}
                                    </p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Progress Tracker -->
        <div class="mt-8 bg-white rounded-2xl shadow-sm border-2 border-dashed border-blue-200 p-6">
            <h3 class="font-bold text-blue-900 mb-4 flex items-center gap-2">
                <span>📊</span> Registro de Progreso Semanal
            </h3>
            <div class="grid grid-cols-7 gap-2">
                @php $dayNames = ['Lun', 'Mar', 'Mié', 'Jue', 'Vie', 'Sáb', 'Dom']; @endphp
                @foreach($dayNames as $dayName)
                    <div class="text-center">
                        <p class="text-xs text-gray-500 mb-2">{{ $dayName }}</p>
                        <div class="w-10 h-10 mx-auto border-2 border-blue-300 rounded-lg bg-blue-50"></div>
                    </div>
                @endforeach
            </div>
            <p class="text-xs text-gray-400 mt-4 text-center">Marca cada día que completes tu entrenamiento ✓</p>
        </div>

        <!-- Workout Notes -->
        @if($workout->notes)
            <div class="mt-6 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-xl border border-blue-200 p-5">
                <h3 class="font-bold text-blue-900 mb-2 flex items-center gap-2">
                    <span>📋</span> Instrucciones Generales
                </h3>
                <p class="text-blue-800 text-sm leading-relaxed">{{ $workout->notes }}</p>
            </div>
        @endif

        <!-- Coach Info -->
        @if(!empty($coach) && ($settings['show_coach_info'] ?? true))
            <div class="mt-6 bg-white rounded-xl shadow-sm border border-gray-100 p-5">
                <div class="flex items-center gap-4">
                    @if(!empty($coach['photo']))
                        <img src="{{ $coach['photo'] }}" alt="{{ $coach['name'] }}" class="w-14 h-14 rounded-full object-cover">
                    @else
                        <div class="w-14 h-14 rounded-full gradient-primary flex items-center justify-center text-white font-bold text-xl">
                            {{ strtoupper(substr($coach['name'] ?? 'C', 0, 1)) }}
                        </div>
                    @endif
                    <div>
                        <p class="text-sm text-gray-500">Tu Entrenador</p>
                        <p class="font-bold text-gray-900">{{ $coach['name'] ?? '' }}</p>
                        <p class="text-sm text-gray-600">{{ $coach['email'] ?? '' }}</p>
                    </div>
                    <div class="ml-auto text-right">
                        <p class="text-xs text-gray-400">¿Dudas? Contacta a tu coach</p>
                        @if(!empty($coach['phone']))
                            <p class="text-sm font-medium text-gray-700">📱 {{ $coach['phone'] }}</p>
                        @endif
                    </div>
                </div>
            </div>
        @endif
    </div>

    <!-- Footer -->
    <div class="fixed bottom-0 left-0 right-0 bg-gray-100 px-8 py-3 border-t border-gray-200">
        <div class="flex items-center justify-between text-xs text-gray-500">
            <p>{{ $settings['site_name'] ?? 'CoachPro' }} - Rutina de Entrenamiento</p>
            <p>Generado el {{ now()->format('d/m/Y H:i') }}</p>
        </div>
    </div>
</body>
</html>
