@extends('pdf.base')

@section('title', 'Factura ' . $invoice->invoice_number)

@section('content')
    <!-- Header -->
    <div class="pdf-header pdf-header-primary">
        <div class="row">
            <div class="col-6">
                @if(isset($settings['logo']) && file_exists($settings['logo']))
                    <img src="{{ $settings['logo'] }}" alt="Logo" style="max-height: 45px; margin-bottom: 10px;">
                @else
                    <div class="logo">{{ $settings['header'] ?? 'CoachPro' }}</div>
                @endif
                <div style="font-size: 10px; opacity: 0.8;">Sistema de Gestión para Entrenadores</div>
            </div>
            <div class="col-6 text-right">
                <h2 style="color: #ffffff; margin-bottom: 5px;">FACTURA</h2>
                <div style="font-size: 16px; font-weight: 600;">{{ $invoice->invoice_number }}</div>
                <div class="mt-2">
                    <span class="badge {{ $invoice->status === 'paid' ? 'badge-success' : ($invoice->status === 'pending' ? 'badge-warning' : 'badge-danger') }}">
                        {{ $invoice->status === 'paid' ? 'PAGADA' : ($invoice->status === 'pending' ? 'PENDIENTE' : 'CANCELADA') }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Invoice Details -->
    <div class="row mb-4">
        <div class="col-6">
            <div class="card">
                <div class="card-header bg-light">
                    <span class="text-primary">📋</span> Datos del Cliente
                </div>
                <div class="card-body">
                    <strong style="font-size: 14px;">{{ $invoice->user->name }}</strong><br>
                    <span class="text-muted">{{ $invoice->user->email }}</span><br>
                    @if($invoice->user->phone)
                        <span class="text-muted">Tel: {{ $invoice->user->phone }}</span>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-6">
            <div class="card">
                <div class="card-header bg-light">
                    <span class="text-primary">📅</span> Información de Factura
                </div>
                <div class="card-body">
                    <table style="border: none; margin: 0;">
                        <tr style="border: none;">
                            <td style="border: none; padding: 3px 10px 3px 0; color: #6b7280;">Fecha emisión:</td>
                            <td style="border: none; padding: 3px 0; font-weight: 600;">{{ $invoice->created_at->format('d/m/Y') }}</td>
                        </tr>
                        @if($invoice->paid_at)
                        <tr style="border: none;">
                            <td style="border: none; padding: 3px 10px 3px 0; color: #6b7280;">Fecha pago:</td>
                            <td style="border: none; padding: 3px 0; font-weight: 600;">{{ $invoice->paid_at->format('d/m/Y') }}</td>
                        </tr>
                        @endif
                        @if($invoice->payment_method)
                        <tr style="border: none;">
                            <td style="border: none; padding: 3px 10px 3px 0; color: #6b7280;">Método:</td>
                            <td style="border: none; padding: 3px 0; font-weight: 600;">
                                {{ $invoice->payment_method === 'stripe' ? 'Tarjeta (Stripe)' : ($invoice->payment_method === 'paypal' ? 'PayPal' : 'Transferencia') }}
                            </td>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Items Table -->
    <div class="section">
        <div class="section-title">
            <span class="text-primary">📦</span> Detalle de la Factura
        </div>
        <table class="table-bordered">
            <thead>
                <tr style="background-color: #f3f4f6;">
                    <th style="width: 55%;">Descripción</th>
                    <th style="width: 10%; text-align: center;">Cant.</th>
                    <th style="width: 17%; text-align: right;">Precio Unit.</th>
                    <th style="width: 18%; text-align: right;">Total</th>
                </tr>
            </thead>
            <tbody>
                @foreach($items as $item)
                <tr>
                    <td>{{ $item['description'] }}</td>
                    <td style="text-align: center;">{{ $item['quantity'] }}</td>
                    <td style="text-align: right;">${{ number_format($item['unit_price'], 2) }}</td>
                    <td style="text-align: right; font-weight: 600;">${{ number_format($item['total'], 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <!-- Totals -->
    <div class="row">
        <div class="col-6">
            @if($invoice->notes || !empty($settings['note']))
            <div class="info-box">
                <strong>📝 Notas:</strong><br>
                @if($invoice->notes)<p style="margin: 5px 0;">{{ $invoice->notes }}</p>@endif
                @if(!empty($settings['note']))<p style="margin: 5px 0; font-style: italic;">{{ $settings['note'] }}</p>@endif
            </div>
            @endif
        </div>
        <div class="col-6">
            <table style="margin-left: auto; width: 100%;">
                <tr style="background-color: #f9fafb;">
                    <td style="padding: 10px 15px; font-weight: 500;">Subtotal:</td>
                    <td style="padding: 10px 15px; text-align: right;">${{ number_format($invoice->subtotal, 2) }}</td>
                </tr>
                @if($invoice->taxes_applied && is_array($invoice->taxes_applied) && count($invoice->taxes_applied) > 0)
                    @foreach($invoice->taxes_applied as $tax)
                    <tr>
                        <td style="padding: 10px 15px; color: #6b7280;">{{ $tax['name'] }}{{ isset($tax['rate']) ? ' (' . $tax['rate'] . '%)' : '' }}:</td>
                        <td style="padding: 10px 15px; text-align: right;">${{ number_format($tax['amount'], 2) }}</td>
                    </tr>
                    @endforeach
                @elseif($invoice->tax > 0)
                <tr>
                    <td style="padding: 10px 15px; color: #6b7280;">Tarifa:</td>
                    <td style="padding: 10px 15px; text-align: right;">${{ number_format($invoice->tax, 2) }}</td>
                </tr>
                @endif
                <tr style="background-color: #3b82f6; color: white;">
                    <td style="padding: 12px 15px; font-weight: 700; font-size: 14px; border-radius: 0 0 0 8px;">TOTAL:</td>
                    <td style="padding: 12px 15px; text-align: right; font-weight: 700; font-size: 16px; border-radius: 0 0 8px 0;">${{ number_format($invoice->total, 2) }}</td>
                </tr>
            </table>
        </div>
    </div>

    <!-- Footer -->
    <div class="pdf-footer">
        <div class="logo text-primary">{{ $settings['header'] ?? 'CoachPro' }}</div>
        <p>{{ $settings['footer'] ?? 'Gracias por su confianza' }}</p>
        @if($invoice->transaction_id)
        <p style="font-size: 9px; color: #9ca3af;">ID Transacción: {{ $invoice->transaction_id }}</p>
        @endif
    </div>
@endsection
