@extends('pdf.base')

@section('title', 'Catálogo de Alimentos')

@section('content')
    <!-- Header -->
    <div class="pdf-header pdf-header-success">
        <div class="logo">🥗 {{ $settings['header'] ?? 'CoachPro' }}</div>
        <h1>Catálogo de Alimentos</h1>
        <p>Base de datos nutricional · {{ count($foods) }} alimentos</p>
    </div>

    <!-- Summary Stats -->
    <div class="stats-grid mb-4">
        <div class="stat-box">
            <span class="stat-value" style="color: #10b981;">{{ count($foods) }}</span>
            <span class="stat-label">Total Alimentos</span>
        </div>
        <div class="stat-box">
            <span class="stat-value" style="color: #3b82f6;">{{ $categories ?? '-' }}</span>
            <span class="stat-label">Categorías</span>
        </div>
        <div class="stat-box">
            <span class="stat-value" style="color: #8b5cf6;">{{ $avgCalories ?? '-' }}</span>
            <span class="stat-label">Kcal Promedio</span>
        </div>
    </div>

    <!-- Foods by Category -->
    @if(isset($groupedFoods))
        @foreach($groupedFoods as $category => $categoryFoods)
        <div class="section">
            <div class="section-title">
                <span style="color: #10b981;">📂</span> {{ $category ?: 'Sin categoría' }}
                <span style="font-weight: normal; font-size: 10px; color: #6b7280;">({{ count($categoryFoods) }} alimentos)</span>
            </div>
            <table class="table-striped table-bordered">
                <thead>
                    <tr style="background-color: #10b981; color: white;">
                        <th style="width: 35%;">Alimento</th>
                        <th style="width: 13%; text-align: center;">Porción</th>
                        <th style="width: 13%; text-align: center;">Calorías</th>
                        <th style="width: 13%; text-align: center;">Proteína</th>
                        <th style="width: 13%; text-align: center;">Carbs</th>
                        <th style="width: 13%; text-align: center;">Grasas</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($categoryFoods as $food)
                    <tr>
                        <td>
                            <strong>{{ $food->name }}</strong>
                            @if($food->brand)
                            <div style="font-size: 9px; color: #6b7280;">{{ $food->brand }}</div>
                            @endif
                        </td>
                        <td style="text-align: center;">{{ $food->serving_size ?? 100 }}g</td>
                        <td style="text-align: center; font-weight: 600; color: #8b5cf6;">{{ round($food->calories) }}</td>
                        <td style="text-align: center; color: #3b82f6;">{{ round($food->proteins, 1) }}g</td>
                        <td style="text-align: center; color: #eab308;">{{ round($food->carbs, 1) }}g</td>
                        <td style="text-align: center; color: #f97316;">{{ round($food->fats, 1) }}g</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @endforeach
    @else
        <!-- Single table without categories -->
        <div class="section">
            <table class="table-striped table-bordered">
                <thead>
                    <tr style="background-color: #10b981; color: white;">
                        <th style="width: 30%;">Alimento</th>
                        <th style="width: 14%;">Categoría</th>
                        <th style="width: 11%; text-align: center;">Porción</th>
                        <th style="width: 11%; text-align: center;">Kcal</th>
                        <th style="width: 11%; text-align: center;">Prot.</th>
                        <th style="width: 11%; text-align: center;">Carbs</th>
                        <th style="width: 11%; text-align: center;">Grasas</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($foods as $food)
                    <tr>
                        <td>
                            <strong>{{ $food->name }}</strong>
                            @if($food->brand)
                            <div style="font-size: 9px; color: #6b7280;">{{ $food->brand }}</div>
                            @endif
                        </td>
                        <td style="font-size: 10px;">{{ $food->category ?? '-' }}</td>
                        <td style="text-align: center;">{{ $food->serving_size ?? 100 }}g</td>
                        <td style="text-align: center; font-weight: 600; color: #8b5cf6;">{{ round($food->calories) }}</td>
                        <td style="text-align: center; color: #3b82f6;">{{ round($food->proteins, 1) }}g</td>
                        <td style="text-align: center; color: #eab308;">{{ round($food->carbs, 1) }}g</td>
                        <td style="text-align: center; color: #f97316;">{{ round($food->fats, 1) }}g</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif

    <!-- Legend -->
    <div class="card mt-4">
        <div class="card-header bg-light">
            <span style="color: #10b981;">ℹ️</span> Información Nutricional
        </div>
        <div class="card-body" style="font-size: 10px; color: #6b7280;">
            <p style="margin: 0;">Los valores nutricionales están expresados por cada 100g de alimento (o porción indicada).</p>
            <div class="row mt-2">
                <div class="col-3"><span style="color: #8b5cf6;">●</span> Calorías: Energía total</div>
                <div class="col-3"><span style="color: #3b82f6;">●</span> Proteínas: Para músculos</div>
                <div class="col-3"><span style="color: #eab308;">●</span> Carbohidratos: Energía rápida</div>
                <div class="col-3"><span style="color: #f97316;">●</span> Grasas: Energía reserva</div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <div class="pdf-footer">
        <div class="logo" style="color: #10b981;">{{ $settings['header'] ?? 'CoachPro' }}</div>
        <p>Catálogo generado automáticamente · Información nutricional de referencia</p>
        @if($settings['footer'] ?? null)
        <p>{{ $settings['footer'] }}</p>
        @endif
    </div>
@endsection
