<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Cuenta Suspendida - {{ config('app.name') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;900&display=swap');
        
        * {
            font-family: 'Inter', sans-serif;
        }

        @keyframes pulse-slow {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.5;
            }
        }

        .animate-pulse-slow {
            animation: pulse-slow 3s cubic-bezier(0.4, 0, 0.6, 1) infinite;
        }

        @keyframes float {
            0%, 100% {
                transform: translateY(0px);
            }
            50% {
                transform: translateY(-20px);
            }
        }

        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
    </style>
</head>
<body class="antialiased bg-[#0A0A0A] min-h-screen flex items-center justify-center p-4">
    <!-- Animated Background -->
    <div class="fixed inset-0 overflow-hidden pointer-events-none">
        <div class="absolute top-1/4 -left-32 w-96 h-96 bg-[#FF6B35] opacity-20 rounded-full blur-[100px] animate-pulse-slow"></div>
        <div class="absolute bottom-1/4 -right-32 w-96 h-96 bg-[#00D4FF] opacity-20 rounded-full blur-[100px] animate-pulse-slow" style="animation-delay: 2s;"></div>
    </div>

    <!-- Main Container -->
    <div class="relative max-w-2xl w-full">
        <!-- Card -->
        <div class="bg-gradient-to-br from-[#1A1A1A] to-[#2D2D2D] rounded-3xl border-2 border-[#FF6B35] shadow-2xl overflow-hidden">
            <!-- Top Accent -->
            <div class="h-2 bg-gradient-to-r from-[#39FF14] via-[#00D4FF] to-[#FF6B35]"></div>

            <div class="p-8 sm:p-12">
                <!-- Icon -->
                <div class="flex justify-center mb-8">
                    <div class="relative">
                        <div class="absolute inset-0 bg-gradient-to-br from-[#FF6B35] to-[#39FF14] opacity-30 rounded-full blur-2xl"></div>
                        <div class="relative w-24 h-24 sm:w-32 sm:h-32 rounded-full bg-gradient-to-br from-[#FF6B35] to-[#39FF14] flex items-center justify-center animate-float">
                            <svg class="w-12 h-12 sm:w-16 sm:h-16 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                            </svg>
                        </div>
                    </div>
                </div>

                <!-- Status Badge -->
                <div class="flex justify-center mb-6">
                    <span class="inline-flex items-center gap-2 px-5 py-2.5 rounded-full text-sm font-bold bg-[#FF6B35]/20 border-2 border-[#FF6B35] text-[#FF6B35]">
                        <span class="relative flex h-2 w-2">
                            <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-[#FF6B35] opacity-75"></span>
                            <span class="relative inline-flex rounded-full h-2 w-2 bg-[#FF6B35]"></span>
                        </span>
                        CUENTA SUSPENDIDA
                    </span>
                </div>

                <!-- Title -->
                <h1 class="text-3xl sm:text-5xl font-black text-center text-white mb-4">
                    Acceso <span class="bg-clip-text text-transparent bg-gradient-to-r from-[#FF6B35] to-[#39FF14]">Restringido</span>
                </h1>

                <!-- Message -->
                <p class="text-gray-400 text-center text-lg mb-8 max-w-md mx-auto">
                    Tu cuenta ha sido suspendida temporalmente. Por favor, contacta al administrador para obtener más información y resolver esta situación.
                </p>

                <!-- Contact Options -->
                <div class="space-y-4 max-w-md mx-auto">
                    <!-- Email Admin -->
                    <a href="mailto:{{ config('mail.from.address') }}" 
                       class="group flex items-center gap-4 p-5 rounded-2xl bg-gradient-to-r from-[#39FF14]/10 to-[#00D4FF]/10 border-2 border-[#39FF14]/30 hover:border-[#39FF14] transition-all duration-300 hover:scale-[1.02]">
                        <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-[#39FF14] to-[#00D4FF] flex items-center justify-center flex-shrink-0">
                            <svg class="w-7 h-7 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                            </svg>
                        </div>
                        <div class="flex-1 text-left">
                            <p class="font-bold text-white group-hover:text-[#39FF14] transition-colors">Enviar Email</p>
                            <p class="text-sm text-gray-400">Contacta al administrador</p>
                        </div>
                        <svg class="w-5 h-5 text-gray-500 group-hover:text-[#39FF14] group-hover:translate-x-1 transition-all" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                        </svg>
                    </a>

                    @if(request()->has('contact'))
                        <!-- Contact Form Link (if contact route exists) -->
                        <a href="{{ route('contact') }}" 
                           class="group flex items-center gap-4 p-5 rounded-2xl bg-gradient-to-r from-[#00D4FF]/10 to-[#FF6B35]/10 border-2 border-[#00D4FF]/30 hover:border-[#00D4FF] transition-all duration-300 hover:scale-[1.02]">
                            <div class="w-14 h-14 rounded-2xl bg-gradient-to-br from-[#00D4FF] to-[#FF6B35] flex items-center justify-center flex-shrink-0">
                                <svg class="w-7 h-7 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                                </svg>
                            </div>
                            <div class="flex-1 text-left">
                                <p class="font-bold text-white group-hover:text-[#00D4FF] transition-colors">Formulario de Contacto</p>
                                <p class="text-sm text-gray-400">Envía un mensaje directo</p>
                            </div>
                            <svg class="w-5 h-5 text-gray-500 group-hover:text-[#00D4FF] group-hover:translate-x-1 transition-all" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                            </svg>
                        </a>
                    @endif
                </div>

                <!-- Logout Button -->
                <div class="mt-10 text-center">
                    <a href="{{ route('logout') }}" 
                       onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                       class="inline-flex items-center gap-2 px-8 py-4 rounded-2xl font-bold text-gray-400 border-2 border-gray-700 hover:border-gray-500 hover:text-white transition-all duration-300">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                        </svg>
                        Cerrar Sesión
                    </a>
                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="hidden">
                        @csrf
                    </form>
                </div>
            </div>
        </div>

        <!-- Footer Note -->
        <p class="text-center text-gray-600 text-sm mt-8">
            Error 403 • {{ config('app.name') }}
        </p>
    </div>
</body>
</html>
