<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Helvetica', 'Arial', sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .email-container {
            background: white;
            border-radius: 12px;
            padding: 40px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .emoji {
            font-size: 48px;
            margin-bottom: 10px;
        }
        h1 {
            color: #10B981;
            margin: 0;
            font-size: 24px;
        }
        .content {
            margin: 30px 0;
            color: #4B5563;
        }
        .highlight {
            background: #ECFDF5;
            border-left: 4px solid #10B981;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .footer {
            text-align: center;
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #E5E7EB;
            color: #6B7280;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <div class="emoji">🥗</div>
            <h1>Tu Plan de Dieta</h1>
        </div>
        
        <div class="content">
            <p>Hola <strong>{{ $clientName }}</strong>,</p>
            
            <p>Tu entrenador ha preparado tu plan de alimentación personalizado.</p>
            
            <div class="highlight">
                <strong>📋 Plan:</strong> {{ $mealPlanName }}
            </div>
            
            <p>Encontrarás adjunto el PDF con todos los detalles de tu dieta, incluyendo:</p>
            <ul>
                <li>✅ Tus comidas diarias</li>
                <li>✅ Macronutrientes calculados</li>
                <li>✅ Porciones y cantidades exactas</li>
                <li>✅ Recomendaciones de hidratación</li>
            </ul>
            
            <p>Recuerda que la constancia es clave para alcanzar tus objetivos. ¡Tú puedes! 💪</p>
        </div>
        
        <div class="footer">
            <p>Este correo fue generado automáticamente desde tu plataforma CoachPro</p>
        </div>
    </div>
</body>
</html>
