<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, viewport-fit=cover">

        <!-- Dark Mode Script (prevents flash) -->
        <script>
            (function() {
                const theme = localStorage.getItem('theme');
                if (theme === 'dark' || (!theme && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
                    document.documentElement.classList.add('dark');
                }
            })();
        </script>

        <!-- PWA Meta Tags -->
        <meta name="theme-color" content="{{ \App\Models\Setting::get('pwa_theme_color', '#4f46e5') }}">
        <meta name="mobile-web-app-capable" content="yes">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
        <meta name="apple-mobile-web-app-title" content="{{ \App\Models\Setting::get('pwa_name', config('app.name', 'CoachPro')) }}">
        <meta name="application-name" content="{{ \App\Models\Setting::get('pwa_name', config('app.name', 'CoachPro')) }}">
        <meta name="msapplication-TileColor" content="{{ \App\Models\Setting::get('pwa_theme_color', '#4f46e5') }}">
        <meta name="msapplication-tap-highlight" content="no">
        <meta name="format-detection" content="telephone=no">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <!-- SEO Meta Tags -->
        <meta name="description" content="{{ \App\Models\Setting::get('seo_description', 'Plataforma profesional para entrenadores personales') }}">
        <meta name="keywords" content="{{ \App\Models\Setting::get('seo_keywords', 'coach, fitness, nutrición') }}">
        <meta name="robots" content="{{ \App\Models\Setting::get('robots_meta', 'index, follow') }}">

        @if(\App\Models\Setting::get('seo_title'))
            <meta property="og:title" content="{{ \App\Models\Setting::get('seo_title') }}">
        @endif

        @if(\App\Models\Setting::get('og_image'))
            <meta property="og:image" content="{{ url('/storage/' . \App\Models\Setting::get('og_image')) }}">
            <meta name="twitter:image" content="{{ url('/storage/' . \App\Models\Setting::get('og_image')) }}">
        @endif
        <meta property="og:type" content="website">
        <meta property="og:url" content="{{ url()->current() }}">
        <meta name="twitter:card" content="summary_large_image">

        <!-- Site Verification -->
        @if(\App\Models\Setting::get('google_site_verification'))
            <meta name="google-site-verification" content="{{ \App\Models\Setting::get('google_site_verification') }}">
        @endif
        @if(\App\Models\Setting::get('bing_site_verification'))
            <meta name="msvalidate.01" content="{{ \App\Models\Setting::get('bing_site_verification') }}">
        @endif

        <!-- Google Tag Manager -->
        @if(\App\Models\Setting::get('google_tag_manager_id'))
            <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
            new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
            })(window,document,'script','dataLayer','{{ \App\Models\Setting::get('google_tag_manager_id') }}');</script>
        @endif

        <!-- Google Analytics -->
        @if(\App\Models\Setting::get('google_analytics_id'))
            <script async src="https://www.googletagmanager.com/gtag/js?id={{ \App\Models\Setting::get('google_analytics_id') }}"></script>
            <script>
                window.dataLayer = window.dataLayer || [];
                function gtag(){dataLayer.push(arguments);}
                gtag('js', new Date());
                gtag('config', '{{ \App\Models\Setting::get('google_analytics_id') }}');
            </script>
        @endif

        <!-- Facebook Pixel -->
        @if(\App\Models\Setting::get('facebook_pixel_id'))
            <script>
                !function(f,b,e,v,n,t,s)
                {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
                n.callMethod.apply(n,arguments):n.queue.push(arguments)};
                if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
                n.queue=[];t=b.createElement(e);t.async=!0;
                t.src=v;s=b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t,s)}(window,document,'script',
                'https://connect.facebook.net/en_US/fbevents.js');
                fbq('init', '{{ \App\Models\Setting::get('facebook_pixel_id') }}');
                fbq('track', 'PageView');
            </script>
            <noscript><img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id={{ \App\Models\Setting::get('facebook_pixel_id') }}&ev=PageView&noscript=1"/></noscript>
        @endif

        <!-- Custom Header Scripts -->
        {!! \App\Models\Setting::get('custom_header_scripts') !!}

        <title inertia>{{ \App\Models\Setting::get('seo_title', config('app.name', 'CoachPro')) }}</title>

        <!-- Favicon & Icons -->
        @if(\App\Models\Setting::get('favicon'))
            <link rel="icon" type="image/png" href="/storage/{{ \App\Models\Setting::get('favicon') }}">
        @else
            <link rel="icon" type="image/svg+xml" href="/favicon.svg">
        @endif

        @if(\App\Models\Setting::get('pwa_apple_icon'))
            <link rel="apple-touch-icon" href="/storage/{{ \App\Models\Setting::get('pwa_apple_icon') }}">
        @else
            <link rel="apple-touch-icon" href="/icons/apple-touch-icon.svg">
        @endif

        @if(\App\Models\Setting::get('pwa_icon_192'))
            <link rel="icon" type="image/png" sizes="192x192" href="/storage/{{ \App\Models\Setting::get('pwa_icon_192') }}">
        @endif

        @if(\App\Models\Setting::get('pwa_icon_512'))
            <link rel="icon" type="image/png" sizes="512x512" href="/storage/{{ \App\Models\Setting::get('pwa_icon_512') }}">
        @endif

        <!-- Splash Screens for iOS -->
        @if(\App\Models\Setting::get('pwa_splash'))
            <link rel="apple-touch-startup-image" href="/storage/{{ \App\Models\Setting::get('pwa_splash') }}">
        @else
            <link rel="apple-touch-startup-image" href="/splash/apple-splash-2048-2732.svg" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2)">
            <link rel="apple-touch-startup-image" href="/splash/apple-splash-1668-2388.svg" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2)">
            <link rel="apple-touch-startup-image" href="/splash/apple-splash-1536-2048.svg" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2)">
            <link rel="apple-touch-startup-image" href="/splash/apple-splash-1125-2436.svg" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3)">
            <link rel="apple-touch-startup-image" href="/splash/apple-splash-1242-2688.svg" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3)">
            <link rel="apple-touch-startup-image" href="/splash/apple-splash-750-1334.svg" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2)">
            <link rel="apple-touch-startup-image" href="/splash/apple-splash-1242-2208.svg" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3)">
        @endif

        <!-- Manifest (generated by vite-plugin-pwa) -->
        <link rel="manifest" href="/build/manifest.webmanifest">

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600,700&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @routes
        @vite(['resources/js/app.js', "resources/js/Pages/{$page['component']}.vue"])
        @inertiaHead

        <!-- PWA Install Prompt Styles -->
        <style>
            /* Prevent pull-to-refresh on mobile */
            body {
                overscroll-behavior-y: contain;
            }

            /* Safe area insets for notched devices */
            .safe-area-top {
                padding-top: env(safe-area-inset-top);
            }
            .safe-area-bottom {
                padding-bottom: env(safe-area-inset-bottom);
            }
            .safe-area-left {
                padding-left: env(safe-area-inset-left);
            }
            .safe-area-right {
                padding-right: env(safe-area-inset-right);
            }

            /* Touch action optimization */
            .touch-manipulation {
                touch-action: manipulation;
            }

            /* Disable text selection on UI elements */
            .no-select {
                -webkit-user-select: none;
                user-select: none;
            }

            /* Hardware acceleration for animations */
            .gpu-accelerated {
                transform: translateZ(0);
                will-change: transform;
            }

            /* iOS-style momentum scrolling */
            .scroll-touch {
                -webkit-overflow-scrolling: touch;
            }

            /* Tap highlight removal */
            * {
                -webkit-tap-highlight-color: transparent;
            }
        </style>
    </head>
    <body class="font-sans antialiased touch-manipulation">
        <!-- Google Tag Manager (noscript) -->
        @if(\App\Models\Setting::get('google_tag_manager_id'))
            <noscript><iframe src="https://www.googletagmanager.com/ns.html?id={{ \App\Models\Setting::get('google_tag_manager_id') }}" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        @endif

        @inertia

        <!-- PWA Update Notification -->
        <div id="pwa-toast" class="hidden fixed bottom-20 left-4 right-4 md:left-auto md:right-4 md:w-96 bg-indigo-600 text-white px-4 py-3 rounded-xl shadow-lg z-50 safe-area-bottom">
            <div class="flex items-center justify-between">
                <span class="text-sm font-medium">Nueva versión disponible</span>
                <button onclick="window.location.reload()" class="ml-4 px-3 py-1 bg-white text-indigo-600 rounded-lg text-sm font-semibold">
                    Actualizar
                </button>
            </div>
        </div>

        <!-- Offline Indicator DESHABILITADO - causaba falsos positivos con PWA Service Worker
        <div id="offline-indicator" class="hidden">Sin conexión</div>
        -->

        <!-- Custom Footer Scripts -->
        {!! \App\Models\Setting::get('custom_footer_scripts') !!}
    </body>
</html>
