<?php

namespace Database\Seeders;

use App\Models\Food;
use Illuminate\Database\Seeder;

class FoodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $foods = [
            // PROTEÍNAS - CARNES
            ['name' => 'Pechuga de Pollo', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 filete mediano', 'serving_weight' => 150, 'calories' => 165, 'proteins' => 31, 'carbs' => 0, 'fats' => 3.6, 'fiber' => 0],
            ['name' => 'Muslo de Pollo sin piel', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 muslo', 'serving_weight' => 100, 'calories' => 177, 'proteins' => 26, 'carbs' => 0, 'fats' => 8, 'fiber' => 0],
            ['name' => 'Pollo entero asado', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 190, 'proteins' => 25, 'carbs' => 0, 'fats' => 10, 'fiber' => 0],
            ['name' => 'Carne de Res magra', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 porción', 'serving_weight' => 150, 'calories' => 250, 'proteins' => 26, 'carbs' => 0, 'fats' => 15, 'fiber' => 0],
            ['name' => 'Lomo de Res', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 filete', 'serving_weight' => 150, 'calories' => 200, 'proteins' => 29, 'carbs' => 0, 'fats' => 9, 'fiber' => 0],
            ['name' => 'Carne molida 90/10', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g cocida', 'serving_weight' => 100, 'calories' => 217, 'proteins' => 26, 'carbs' => 0, 'fats' => 12, 'fiber' => 0],
            ['name' => 'Carne molida 80/20', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g cocida', 'serving_weight' => 100, 'calories' => 254, 'proteins' => 24, 'carbs' => 0, 'fats' => 17, 'fiber' => 0],
            ['name' => 'Filete Mignon', 'category' => 'Proteínas', 'meal_type' => 'cena', 'serving_size' => '1 filete', 'serving_weight' => 170, 'calories' => 275, 'proteins' => 43, 'carbs' => 0, 'fats' => 11, 'fiber' => 0],
            ['name' => 'Pavo pechuga', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 porción', 'serving_weight' => 100, 'calories' => 135, 'proteins' => 30, 'carbs' => 0, 'fats' => 1, 'fiber' => 0],
            ['name' => 'Pavo molido', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g cocido', 'serving_weight' => 100, 'calories' => 170, 'proteins' => 27, 'carbs' => 0, 'fats' => 7, 'fiber' => 0],
            ['name' => 'Cerdo lomo', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 chuleta', 'serving_weight' => 150, 'calories' => 206, 'proteins' => 29, 'carbs' => 0, 'fats' => 9, 'fiber' => 0],
            ['name' => 'Chuleta de Cerdo', 'category' => 'Proteínas', 'meal_type' => 'cena', 'serving_size' => '1 chuleta mediana', 'serving_weight' => 150, 'calories' => 231, 'proteins' => 27, 'carbs' => 0, 'fats' => 13, 'fiber' => 0],
            ['name' => 'Cordero pierna', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 282, 'proteins' => 25, 'carbs' => 0, 'fats' => 20, 'fiber' => 0],
            ['name' => 'Conejo', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 173, 'proteins' => 33, 'carbs' => 0, 'fats' => 3.5, 'fiber' => 0],
            ['name' => 'Hígado de Res', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 175, 'proteins' => 26, 'carbs' => 5, 'fats' => 5, 'fiber' => 0],
            ['name' => 'Jamón York bajo en grasa', 'category' => 'Proteínas', 'meal_type' => 'desayuno', 'serving_size' => '2 lonchas', 'serving_weight' => 50, 'calories' => 55, 'proteins' => 10, 'carbs' => 1, 'fats' => 1.5, 'fiber' => 0],
            ['name' => 'Jamón Serrano', 'category' => 'Proteínas', 'meal_type' => 'merienda', 'serving_size' => '2 lonchas', 'serving_weight' => 30, 'calories' => 70, 'proteins' => 11, 'carbs' => 0, 'fats' => 3, 'fiber' => 0],
            ['name' => 'Bacon/Tocino', 'category' => 'Proteínas', 'meal_type' => 'desayuno', 'serving_size' => '2 tiras', 'serving_weight' => 30, 'calories' => 130, 'proteins' => 9, 'carbs' => 0, 'fats' => 10, 'fiber' => 0],
            ['name' => 'Salchicha de Pollo', 'category' => 'Proteínas', 'meal_type' => 'desayuno', 'serving_size' => '2 unidades', 'serving_weight' => 60, 'calories' => 110, 'proteins' => 12, 'carbs' => 2, 'fats' => 6, 'fiber' => 0],
            ['name' => 'Venado/Ciervo', 'category' => 'Proteínas', 'meal_type' => 'cena', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 158, 'proteins' => 30, 'carbs' => 0, 'fats' => 3.2, 'fiber' => 0],

            // PROTEÍNAS - PESCADOS Y MARISCOS
            ['name' => 'Salmón', 'category' => 'Proteínas', 'meal_type' => 'cena', 'serving_size' => '1 filete', 'serving_weight' => 150, 'calories' => 280, 'proteins' => 30, 'carbs' => 0, 'fats' => 17, 'fiber' => 0],
            ['name' => 'Salmón ahumado', 'category' => 'Proteínas', 'meal_type' => 'desayuno', 'serving_size' => '50g', 'serving_weight' => 50, 'calories' => 90, 'proteins' => 12, 'carbs' => 0, 'fats' => 4.5, 'fiber' => 0],
            ['name' => 'Atún fresco', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 filete', 'serving_weight' => 150, 'calories' => 184, 'proteins' => 40, 'carbs' => 0, 'fats' => 1.5, 'fiber' => 0],
            ['name' => 'Atún en lata (en agua)', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 lata escurrida', 'serving_weight' => 80, 'calories' => 90, 'proteins' => 20, 'carbs' => 0, 'fats' => 1, 'fiber' => 0],
            ['name' => 'Atún en lata (en aceite)', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 lata escurrida', 'serving_weight' => 80, 'calories' => 150, 'proteins' => 20, 'carbs' => 0, 'fats' => 8, 'fiber' => 0],
            ['name' => 'Tilapia', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 filete', 'serving_weight' => 150, 'calories' => 145, 'proteins' => 30, 'carbs' => 0, 'fats' => 2.5, 'fiber' => 0],
            ['name' => 'Merluza', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 filete', 'serving_weight' => 150, 'calories' => 130, 'proteins' => 27, 'carbs' => 0, 'fats' => 2, 'fiber' => 0],
            ['name' => 'Bacalao fresco', 'category' => 'Proteínas', 'meal_type' => 'cena', 'serving_size' => '1 filete', 'serving_weight' => 150, 'calories' => 118, 'proteins' => 26, 'carbs' => 0, 'fats' => 1, 'fiber' => 0],
            ['name' => 'Lubina/Róbalo', 'category' => 'Proteínas', 'meal_type' => 'cena', 'serving_size' => '1 filete', 'serving_weight' => 150, 'calories' => 165, 'proteins' => 32, 'carbs' => 0, 'fats' => 3.5, 'fiber' => 0],
            ['name' => 'Dorada', 'category' => 'Proteínas', 'meal_type' => 'cena', 'serving_size' => '1 pieza', 'serving_weight' => 150, 'calories' => 155, 'proteins' => 30, 'carbs' => 0, 'fats' => 3, 'fiber' => 0],
            ['name' => 'Trucha', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 filete', 'serving_weight' => 150, 'calories' => 200, 'proteins' => 30, 'carbs' => 0, 'fats' => 8, 'fiber' => 0],
            ['name' => 'Sardinas frescas', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 208, 'proteins' => 25, 'carbs' => 0, 'fats' => 11, 'fiber' => 0],
            ['name' => 'Sardinas en lata', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '1 lata', 'serving_weight' => 85, 'calories' => 180, 'proteins' => 21, 'carbs' => 0, 'fats' => 10, 'fiber' => 0],
            ['name' => 'Anchoas', 'category' => 'Proteínas', 'meal_type' => 'merienda', 'serving_size' => '30g', 'serving_weight' => 30, 'calories' => 56, 'proteins' => 8, 'carbs' => 0, 'fats' => 2.5, 'fiber' => 0],
            ['name' => 'Camarones/Gambas', 'category' => 'Proteínas', 'meal_type' => 'cena', 'serving_size' => '100g cocidos', 'serving_weight' => 100, 'calories' => 99, 'proteins' => 24, 'carbs' => 0, 'fats' => 0.3, 'fiber' => 0],
            ['name' => 'Langostinos', 'category' => 'Proteínas', 'meal_type' => 'cena', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 105, 'proteins' => 25, 'carbs' => 0, 'fats' => 0.5, 'fiber' => 0],
            ['name' => 'Pulpo', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 82, 'proteins' => 15, 'carbs' => 2, 'fats' => 1, 'fiber' => 0],
            ['name' => 'Calamar', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 92, 'proteins' => 18, 'carbs' => 3, 'fats' => 1.4, 'fiber' => 0],
            ['name' => 'Mejillones', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g carne', 'serving_weight' => 100, 'calories' => 86, 'proteins' => 12, 'carbs' => 4, 'fats' => 2, 'fiber' => 0],
            ['name' => 'Almejas', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g carne', 'serving_weight' => 100, 'calories' => 74, 'proteins' => 13, 'carbs' => 3, 'fats' => 1, 'fiber' => 0],
            ['name' => 'Vieiras', 'category' => 'Proteínas', 'meal_type' => 'cena', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 88, 'proteins' => 17, 'carbs' => 3, 'fats' => 0.8, 'fiber' => 0],
            ['name' => 'Cangrejo', 'category' => 'Proteínas', 'meal_type' => 'almuerzo', 'serving_size' => '100g carne', 'serving_weight' => 100, 'calories' => 83, 'proteins' => 18, 'carbs' => 0, 'fats' => 1, 'fiber' => 0],
            ['name' => 'Langosta', 'category' => 'Proteínas', 'meal_type' => 'cena', 'serving_size' => '100g carne', 'serving_weight' => 100, 'calories' => 89, 'proteins' => 19, 'carbs' => 0.5, 'fats' => 0.5, 'fiber' => 0],

            // PROTEÍNAS - HUEVOS Y LÁCTEOS
            ['name' => 'Huevo entero', 'category' => 'Proteínas', 'meal_type' => 'desayuno', 'serving_size' => '1 unidad grande', 'serving_weight' => 50, 'calories' => 70, 'proteins' => 6, 'carbs' => 0.6, 'fats' => 5, 'fiber' => 0],
            ['name' => 'Clara de Huevo', 'category' => 'Proteínas', 'meal_type' => 'desayuno', 'serving_size' => '1 unidad', 'serving_weight' => 33, 'calories' => 17, 'proteins' => 3.6, 'carbs' => 0.2, 'fats' => 0.1, 'fiber' => 0],
            ['name' => 'Yema de Huevo', 'category' => 'Proteínas', 'meal_type' => 'desayuno', 'serving_size' => '1 unidad', 'serving_weight' => 17, 'calories' => 55, 'proteins' => 2.7, 'carbs' => 0.6, 'fats' => 4.5, 'fiber' => 0],
            ['name' => 'Huevos de codorniz', 'category' => 'Proteínas', 'meal_type' => 'desayuno', 'serving_size' => '5 unidades', 'serving_weight' => 50, 'calories' => 79, 'proteins' => 6.5, 'carbs' => 0.4, 'fats' => 5.5, 'fiber' => 0],
            ['name' => 'Queso Cottage', 'category' => 'Lácteos', 'meal_type' => 'merienda', 'serving_size' => '1 taza', 'serving_weight' => 226, 'calories' => 206, 'proteins' => 28, 'carbs' => 6, 'fats' => 8, 'fiber' => 0],
            ['name' => 'Queso Cottage bajo en grasa', 'category' => 'Lácteos', 'meal_type' => 'merienda', 'serving_size' => '1 taza', 'serving_weight' => 226, 'calories' => 163, 'proteins' => 28, 'carbs' => 6, 'fats' => 2.3, 'fiber' => 0],
            ['name' => 'Queso Mozzarella', 'category' => 'Lácteos', 'meal_type' => 'almuerzo', 'serving_size' => '30g', 'serving_weight' => 30, 'calories' => 85, 'proteins' => 6, 'carbs' => 0.6, 'fats' => 6.5, 'fiber' => 0],
            ['name' => 'Queso Mozzarella light', 'category' => 'Lácteos', 'meal_type' => 'almuerzo', 'serving_size' => '30g', 'serving_weight' => 30, 'calories' => 60, 'proteins' => 7, 'carbs' => 1, 'fats' => 3, 'fiber' => 0],
            ['name' => 'Queso Parmesano', 'category' => 'Lácteos', 'meal_type' => 'almuerzo', 'serving_size' => '20g rallado', 'serving_weight' => 20, 'calories' => 86, 'proteins' => 8, 'carbs' => 0.8, 'fats' => 6, 'fiber' => 0],
            ['name' => 'Queso Cheddar', 'category' => 'Lácteos', 'meal_type' => 'merienda', 'serving_size' => '30g', 'serving_weight' => 30, 'calories' => 120, 'proteins' => 7, 'carbs' => 0.4, 'fats' => 10, 'fiber' => 0],
            ['name' => 'Queso Feta', 'category' => 'Lácteos', 'meal_type' => 'almuerzo', 'serving_size' => '30g', 'serving_weight' => 30, 'calories' => 75, 'proteins' => 4, 'carbs' => 1, 'fats' => 6, 'fiber' => 0],
            ['name' => 'Queso Fresco/Burgos', 'category' => 'Lácteos', 'meal_type' => 'desayuno', 'serving_size' => '50g', 'serving_weight' => 50, 'calories' => 88, 'proteins' => 8, 'carbs' => 2.5, 'fats' => 5, 'fiber' => 0],
            ['name' => 'Queso Crema', 'category' => 'Lácteos', 'meal_type' => 'desayuno', 'serving_size' => '30g', 'serving_weight' => 30, 'calories' => 100, 'proteins' => 2, 'carbs' => 1, 'fats' => 10, 'fiber' => 0],
            ['name' => 'Queso Crema light', 'category' => 'Lácteos', 'meal_type' => 'desayuno', 'serving_size' => '30g', 'serving_weight' => 30, 'calories' => 50, 'proteins' => 3, 'carbs' => 2, 'fats' => 3.5, 'fiber' => 0],
            ['name' => 'Requesón', 'category' => 'Lácteos', 'meal_type' => 'desayuno', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 98, 'proteins' => 11, 'carbs' => 4, 'fats' => 4, 'fiber' => 0],
            ['name' => 'Leche entera', 'category' => 'Lácteos', 'meal_type' => 'desayuno', 'serving_size' => '1 vaso', 'serving_weight' => 250, 'calories' => 150, 'proteins' => 8, 'carbs' => 12, 'fats' => 8, 'fiber' => 0],
            ['name' => 'Leche desnatada', 'category' => 'Lácteos', 'meal_type' => 'desayuno', 'serving_size' => '1 vaso', 'serving_weight' => 250, 'calories' => 90, 'proteins' => 8.5, 'carbs' => 12.5, 'fats' => 0.2, 'fiber' => 0],
            ['name' => 'Leche semidesnatada', 'category' => 'Lácteos', 'meal_type' => 'desayuno', 'serving_size' => '1 vaso', 'serving_weight' => 250, 'calories' => 115, 'proteins' => 8, 'carbs' => 12, 'fats' => 4, 'fiber' => 0],
            ['name' => 'Yogur natural', 'category' => 'Lácteos', 'meal_type' => 'merienda', 'serving_size' => '1 unidad', 'serving_weight' => 125, 'calories' => 75, 'proteins' => 5, 'carbs' => 6, 'fats' => 4, 'fiber' => 0],
            ['name' => 'Yogur Griego natural', 'category' => 'Lácteos', 'meal_type' => 'merienda', 'serving_size' => '1 unidad', 'serving_weight' => 170, 'calories' => 150, 'proteins' => 15, 'carbs' => 6, 'fats' => 8, 'fiber' => 0],
            ['name' => 'Yogur Griego 0%', 'category' => 'Lácteos', 'meal_type' => 'merienda', 'serving_size' => '1 unidad', 'serving_weight' => 170, 'calories' => 100, 'proteins' => 17, 'carbs' => 6, 'fats' => 0.7, 'fiber' => 0],
            ['name' => 'Skyr', 'category' => 'Lácteos', 'meal_type' => 'merienda', 'serving_size' => '1 unidad', 'serving_weight' => 150, 'calories' => 95, 'proteins' => 17, 'carbs' => 6, 'fats' => 0.2, 'fiber' => 0],
            ['name' => 'Kéfir', 'category' => 'Lácteos', 'meal_type' => 'desayuno', 'serving_size' => '1 vaso', 'serving_weight' => 250, 'calories' => 110, 'proteins' => 9, 'carbs' => 10, 'fats' => 3.5, 'fiber' => 0],

            // PROTEÍNAS VEGETALES
            ['name' => 'Tofu firme', 'category' => 'Proteínas Vegetales', 'meal_type' => 'almuerzo', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 144, 'proteins' => 17, 'carbs' => 3, 'fats' => 8, 'fiber' => 2],
            ['name' => 'Tofu suave/sedoso', 'category' => 'Proteínas Vegetales', 'meal_type' => 'almuerzo', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 55, 'proteins' => 5, 'carbs' => 2, 'fats' => 3, 'fiber' => 0.2],
            ['name' => 'Tempeh', 'category' => 'Proteínas Vegetales', 'meal_type' => 'almuerzo', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 195, 'proteins' => 20, 'carbs' => 8, 'fats' => 11, 'fiber' => 5],
            ['name' => 'Seitán', 'category' => 'Proteínas Vegetales', 'meal_type' => 'almuerzo', 'serving_size' => '100g', 'serving_weight' => 100, 'calories' => 120, 'proteins' => 25, 'carbs' => 4, 'fats' => 0.5, 'fiber' => 0.5],
            ['name' => 'Edamame', 'category' => 'Proteínas Vegetales', 'meal_type' => 'merienda', 'serving_size' => '1 taza', 'serving_weight' => 155, 'calories' => 189, 'proteins' => 18.5, 'carbs' => 14, 'fats' => 8, 'fiber' => 8],
            ['name' => 'Lentejas cocidas', 'category' => 'Legumbres', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 198, 'calories' => 230, 'proteins' => 18, 'carbs' => 40, 'fats' => 0.8, 'fiber' => 16],
            ['name' => 'Garbanzos cocidos', 'category' => 'Legumbres', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 164, 'calories' => 269, 'proteins' => 15, 'carbs' => 45, 'fats' => 4, 'fiber' => 12.5],
            ['name' => 'Frijoles/Alubias negras', 'category' => 'Legumbres', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 172, 'calories' => 227, 'proteins' => 15, 'carbs' => 41, 'fats' => 0.9, 'fiber' => 15],
            ['name' => 'Frijoles/Alubias rojas', 'category' => 'Legumbres', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 177, 'calories' => 225, 'proteins' => 15, 'carbs' => 40, 'fats' => 0.9, 'fiber' => 13],
            ['name' => 'Habas cocidas', 'category' => 'Legumbres', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 170, 'calories' => 187, 'proteins' => 13, 'carbs' => 33, 'fats' => 0.7, 'fiber' => 9],
            ['name' => 'Guisantes cocidos', 'category' => 'Legumbres', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 160, 'calories' => 134, 'proteins' => 9, 'carbs' => 25, 'fats' => 0.4, 'fiber' => 9],
            ['name' => 'Hummus', 'category' => 'Legumbres', 'meal_type' => 'merienda', 'serving_size' => '2 cucharadas', 'serving_weight' => 30, 'calories' => 70, 'proteins' => 2, 'carbs' => 6, 'fats' => 5, 'fiber' => 1],

            // CARBOHIDRATOS - CEREALES Y GRANOS
            ['name' => 'Arroz blanco cocido', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 158, 'calories' => 205, 'proteins' => 4.3, 'carbs' => 45, 'fats' => 0.4, 'fiber' => 0.6],
            ['name' => 'Arroz integral cocido', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 195, 'calories' => 218, 'proteins' => 5, 'carbs' => 46, 'fats' => 1.8, 'fiber' => 3.5],
            ['name' => 'Arroz basmati cocido', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 158, 'calories' => 200, 'proteins' => 4.5, 'carbs' => 44, 'fats' => 0.5, 'fiber' => 0.7],
            ['name' => 'Quinoa cocida', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 185, 'calories' => 222, 'proteins' => 8, 'carbs' => 39, 'fats' => 3.5, 'fiber' => 5],
            ['name' => 'Avena en hojuelas', 'category' => 'Carbohidratos', 'meal_type' => 'desayuno', 'serving_size' => '1/2 taza seca', 'serving_weight' => 40, 'calories' => 150, 'proteins' => 5, 'carbs' => 27, 'fats' => 3, 'fiber' => 4],
            ['name' => 'Avena instantánea', 'category' => 'Carbohidratos', 'meal_type' => 'desayuno', 'serving_size' => '1 sobre', 'serving_weight' => 28, 'calories' => 100, 'proteins' => 4, 'carbs' => 19, 'fats' => 2, 'fiber' => 3],
            ['name' => 'Cous Cous cocido', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 157, 'calories' => 176, 'proteins' => 6, 'carbs' => 36, 'fats' => 0.3, 'fiber' => 2],
            ['name' => 'Bulgur cocido', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 182, 'calories' => 151, 'proteins' => 5.6, 'carbs' => 34, 'fats' => 0.4, 'fiber' => 8],
            ['name' => 'Pasta integral cocida', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 140, 'calories' => 174, 'proteins' => 7.5, 'carbs' => 37, 'fats' => 0.8, 'fiber' => 6],
            ['name' => 'Pasta regular cocida', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 140, 'calories' => 220, 'proteins' => 8, 'carbs' => 43, 'fats' => 1.3, 'fiber' => 2.5],
            ['name' => 'Espaguetis cocidos', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 140, 'calories' => 221, 'proteins' => 8, 'carbs' => 43, 'fats' => 1.3, 'fiber' => 2.5],
            ['name' => 'Fideos de arroz cocidos', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 176, 'calories' => 192, 'proteins' => 1.6, 'carbs' => 44, 'fats' => 0.4, 'fiber' => 1.8],
            ['name' => 'Cebada perlada cocida', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 157, 'calories' => 193, 'proteins' => 3.5, 'carbs' => 44, 'fats' => 0.7, 'fiber' => 6],
            ['name' => 'Polenta/Maíz molido', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza cocida', 'serving_weight' => 240, 'calories' => 146, 'proteins' => 3.5, 'carbs' => 32, 'fats' => 0.5, 'fiber' => 2],
            ['name' => 'Trigo sarraceno cocido', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 168, 'calories' => 155, 'proteins' => 5.7, 'carbs' => 33, 'fats' => 1, 'fiber' => 4.5],
            ['name' => 'Mijo cocido', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 174, 'calories' => 207, 'proteins' => 6, 'carbs' => 41, 'fats' => 1.7, 'fiber' => 2.3],

            // CARBOHIDRATOS - PANES Y PRODUCTOS HORNEADOS
            ['name' => 'Pan integral', 'category' => 'Carbohidratos', 'meal_type' => 'desayuno', 'serving_size' => '1 rebanada', 'serving_weight' => 30, 'calories' => 81, 'proteins' => 4, 'carbs' => 14, 'fats' => 1, 'fiber' => 2],
            ['name' => 'Pan blanco', 'category' => 'Carbohidratos', 'meal_type' => 'desayuno', 'serving_size' => '1 rebanada', 'serving_weight' => 30, 'calories' => 79, 'proteins' => 2.7, 'carbs' => 15, 'fats' => 1, 'fiber' => 0.7],
            ['name' => 'Pan de centeno', 'category' => 'Carbohidratos', 'meal_type' => 'desayuno', 'serving_size' => '1 rebanada', 'serving_weight' => 32, 'calories' => 83, 'proteins' => 2.7, 'carbs' => 15, 'fats' => 1, 'fiber' => 1.9],
            ['name' => 'Pan pita integral', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 unidad pequeña', 'serving_weight' => 28, 'calories' => 74, 'proteins' => 2.7, 'carbs' => 15, 'fats' => 0.7, 'fiber' => 2],
            ['name' => 'Tortilla de maíz', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 unidad', 'serving_weight' => 24, 'calories' => 52, 'proteins' => 1.4, 'carbs' => 11, 'fats' => 0.7, 'fiber' => 1.5],
            ['name' => 'Tortilla de harina integral', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 unidad mediana', 'serving_weight' => 45, 'calories' => 120, 'proteins' => 3, 'carbs' => 20, 'fats' => 3, 'fiber' => 2],
            ['name' => 'Bagel integral', 'category' => 'Carbohidratos', 'meal_type' => 'desayuno', 'serving_size' => '1 unidad', 'serving_weight' => 85, 'calories' => 227, 'proteins' => 9, 'carbs' => 44, 'fats' => 1.5, 'fiber' => 4],
            ['name' => 'Tostadas de arroz', 'category' => 'Carbohidratos', 'meal_type' => 'merienda', 'serving_size' => '2 unidades', 'serving_weight' => 18, 'calories' => 70, 'proteins' => 1.5, 'carbs' => 15, 'fats' => 0.5, 'fiber' => 0.4],
            ['name' => 'Crackers integrales', 'category' => 'Carbohidratos', 'meal_type' => 'merienda', 'serving_size' => '5 unidades', 'serving_weight' => 30, 'calories' => 110, 'proteins' => 3, 'carbs' => 19, 'fats' => 3, 'fiber' => 3],
            ['name' => 'Muffin inglés integral', 'category' => 'Carbohidratos', 'meal_type' => 'desayuno', 'serving_size' => '1 unidad', 'serving_weight' => 57, 'calories' => 127, 'proteins' => 5, 'carbs' => 25, 'fats' => 1, 'fiber' => 4],

            // CARBOHIDRATOS - TUBÉRCULOS
            ['name' => 'Papa/Patata cocida', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 mediana', 'serving_weight' => 150, 'calories' => 130, 'proteins' => 3, 'carbs' => 30, 'fats' => 0.1, 'fiber' => 2.5],
            ['name' => 'Papa/Patata asada', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 mediana', 'serving_weight' => 173, 'calories' => 161, 'proteins' => 4.3, 'carbs' => 37, 'fats' => 0.2, 'fiber' => 4],
            ['name' => 'Batata/Camote cocido', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 mediana', 'serving_weight' => 150, 'calories' => 135, 'proteins' => 2, 'carbs' => 31, 'fats' => 0.1, 'fiber' => 4.5],
            ['name' => 'Yuca cocida', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 206, 'calories' => 330, 'proteins' => 2.8, 'carbs' => 78, 'fats' => 0.6, 'fiber' => 3.7],
            ['name' => 'Ñame cocido', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 136, 'calories' => 158, 'proteins' => 2, 'carbs' => 38, 'fats' => 0.2, 'fiber' => 5.3],
            ['name' => 'Plátano macho cocido', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 154, 'calories' => 215, 'proteins' => 1.5, 'carbs' => 58, 'fats' => 0.2, 'fiber' => 3.5],
            ['name' => 'Maíz/Elote cocido', 'category' => 'Carbohidratos', 'meal_type' => 'almuerzo', 'serving_size' => '1 mazorca mediana', 'serving_weight' => 90, 'calories' => 88, 'proteins' => 3, 'carbs' => 19, 'fats' => 1.4, 'fiber' => 2],

            // FRUTAS
            ['name' => 'Manzana', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '1 mediana', 'serving_weight' => 182, 'calories' => 95, 'proteins' => 0.5, 'carbs' => 25, 'fats' => 0.3, 'fiber' => 4.4],
            ['name' => 'Banana/Plátano', 'category' => 'Frutas', 'meal_type' => 'pre_workout', 'serving_size' => '1 mediana', 'serving_weight' => 118, 'calories' => 105, 'proteins' => 1.3, 'carbs' => 27, 'fats' => 0.4, 'fiber' => 3.1],
            ['name' => 'Naranja', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '1 mediana', 'serving_weight' => 131, 'calories' => 62, 'proteins' => 1.2, 'carbs' => 15, 'fats' => 0.2, 'fiber' => 3.1],
            ['name' => 'Fresas', 'category' => 'Frutas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza', 'serving_weight' => 152, 'calories' => 49, 'proteins' => 1, 'carbs' => 12, 'fats' => 0.5, 'fiber' => 3],
            ['name' => 'Arándanos/Blueberries', 'category' => 'Frutas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza', 'serving_weight' => 148, 'calories' => 84, 'proteins' => 1.1, 'carbs' => 21, 'fats' => 0.5, 'fiber' => 3.6],
            ['name' => 'Frambuesas', 'category' => 'Frutas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza', 'serving_weight' => 123, 'calories' => 64, 'proteins' => 1.5, 'carbs' => 15, 'fats' => 0.8, 'fiber' => 8],
            ['name' => 'Moras/Blackberries', 'category' => 'Frutas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza', 'serving_weight' => 144, 'calories' => 62, 'proteins' => 2, 'carbs' => 14, 'fats' => 0.7, 'fiber' => 7.6],
            ['name' => 'Uvas', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '1 taza', 'serving_weight' => 151, 'calories' => 104, 'proteins' => 1.1, 'carbs' => 27, 'fats' => 0.2, 'fiber' => 1.4],
            ['name' => 'Piña/Ananá', 'category' => 'Frutas', 'meal_type' => 'post_workout', 'serving_size' => '1 taza picada', 'serving_weight' => 165, 'calories' => 82, 'proteins' => 0.9, 'carbs' => 22, 'fats' => 0.2, 'fiber' => 2.3],
            ['name' => 'Mango', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '1 taza picado', 'serving_weight' => 165, 'calories' => 99, 'proteins' => 1.4, 'carbs' => 25, 'fats' => 0.6, 'fiber' => 2.6],
            ['name' => 'Papaya', 'category' => 'Frutas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza picada', 'serving_weight' => 145, 'calories' => 62, 'proteins' => 0.7, 'carbs' => 16, 'fats' => 0.4, 'fiber' => 2.5],
            ['name' => 'Melón', 'category' => 'Frutas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza picado', 'serving_weight' => 177, 'calories' => 60, 'proteins' => 1.5, 'carbs' => 14, 'fats' => 0.3, 'fiber' => 1.6],
            ['name' => 'Sandía', 'category' => 'Frutas', 'meal_type' => 'post_workout', 'serving_size' => '1 taza picada', 'serving_weight' => 152, 'calories' => 46, 'proteins' => 0.9, 'carbs' => 11.5, 'fats' => 0.2, 'fiber' => 0.6],
            ['name' => 'Pera', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '1 mediana', 'serving_weight' => 178, 'calories' => 102, 'proteins' => 0.6, 'carbs' => 27, 'fats' => 0.2, 'fiber' => 5.5],
            ['name' => 'Melocotón/Durazno', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '1 mediano', 'serving_weight' => 150, 'calories' => 59, 'proteins' => 1.4, 'carbs' => 14, 'fats' => 0.4, 'fiber' => 2.3],
            ['name' => 'Nectarina', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '1 mediana', 'serving_weight' => 142, 'calories' => 62, 'proteins' => 1.5, 'carbs' => 15, 'fats' => 0.4, 'fiber' => 2.4],
            ['name' => 'Cerezas', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '1 taza', 'serving_weight' => 138, 'calories' => 87, 'proteins' => 1.5, 'carbs' => 22, 'fats' => 0.3, 'fiber' => 2.9],
            ['name' => 'Kiwi', 'category' => 'Frutas', 'meal_type' => 'desayuno', 'serving_size' => '1 mediano', 'serving_weight' => 76, 'calories' => 46, 'proteins' => 0.9, 'carbs' => 11, 'fats' => 0.4, 'fiber' => 2.3],
            ['name' => 'Pomelo/Toronja', 'category' => 'Frutas', 'meal_type' => 'desayuno', 'serving_size' => '1/2 unidad', 'serving_weight' => 123, 'calories' => 52, 'proteins' => 0.9, 'carbs' => 13, 'fats' => 0.2, 'fiber' => 2],
            ['name' => 'Mandarina', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '1 mediana', 'serving_weight' => 88, 'calories' => 47, 'proteins' => 0.7, 'carbs' => 12, 'fats' => 0.3, 'fiber' => 1.6],
            ['name' => 'Granada', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '1/2 unidad', 'serving_weight' => 87, 'calories' => 72, 'proteins' => 1.5, 'carbs' => 16, 'fats' => 1, 'fiber' => 3.5],
            ['name' => 'Higos frescos', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '2 medianos', 'serving_weight' => 100, 'calories' => 74, 'proteins' => 0.8, 'carbs' => 19, 'fats' => 0.3, 'fiber' => 2.9],
            ['name' => 'Aguacate/Palta', 'category' => 'Frutas', 'meal_type' => 'almuerzo', 'serving_size' => '1/2 unidad', 'serving_weight' => 68, 'calories' => 114, 'proteins' => 1.3, 'carbs' => 6, 'fats' => 10.5, 'fiber' => 4.6],
            ['name' => 'Coco fresco', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '1/4 taza rallado', 'serving_weight' => 20, 'calories' => 71, 'proteins' => 0.7, 'carbs' => 3, 'fats' => 6.7, 'fiber' => 1.8],
            ['name' => 'Dátiles secos', 'category' => 'Frutas', 'meal_type' => 'pre_workout', 'serving_size' => '3 unidades', 'serving_weight' => 24, 'calories' => 67, 'proteins' => 0.4, 'carbs' => 18, 'fats' => 0, 'fiber' => 1.6],
            ['name' => 'Pasas', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '1/4 taza', 'serving_weight' => 36, 'calories' => 108, 'proteins' => 1.1, 'carbs' => 29, 'fats' => 0.2, 'fiber' => 1.3],
            ['name' => 'Ciruelas pasas', 'category' => 'Frutas', 'meal_type' => 'merienda', 'serving_size' => '5 unidades', 'serving_weight' => 42, 'calories' => 100, 'proteins' => 0.9, 'carbs' => 26, 'fats' => 0.2, 'fiber' => 3],

            // VERDURAS
            ['name' => 'Brócoli cocido', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 156, 'calories' => 55, 'proteins' => 3.7, 'carbs' => 11, 'fats' => 0.6, 'fiber' => 5.1],
            ['name' => 'Espinacas frescas', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '2 tazas', 'serving_weight' => 60, 'calories' => 14, 'proteins' => 1.7, 'carbs' => 2.2, 'fats' => 0.2, 'fiber' => 1.3],
            ['name' => 'Espinacas cocidas', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 180, 'calories' => 41, 'proteins' => 5.3, 'carbs' => 7, 'fats' => 0.5, 'fiber' => 4.3],
            ['name' => 'Kale/Col rizada', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza picado', 'serving_weight' => 67, 'calories' => 33, 'proteins' => 2.2, 'carbs' => 6, 'fats' => 0.5, 'fiber' => 1.3],
            ['name' => 'Lechuga romana', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '2 tazas', 'serving_weight' => 94, 'calories' => 16, 'proteins' => 1.2, 'carbs' => 3, 'fats' => 0.2, 'fiber' => 2],
            ['name' => 'Lechuga iceberg', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '2 tazas', 'serving_weight' => 94, 'calories' => 13, 'proteins' => 0.9, 'carbs' => 2.8, 'fats' => 0.1, 'fiber' => 1.1],
            ['name' => 'Rúcula/Arúgula', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '2 tazas', 'serving_weight' => 40, 'calories' => 10, 'proteins' => 1, 'carbs' => 1.5, 'fats' => 0.3, 'fiber' => 0.6],
            ['name' => 'Acelgas cocidas', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 175, 'calories' => 35, 'proteins' => 3.3, 'carbs' => 7, 'fats' => 0.1, 'fiber' => 3.7],
            ['name' => 'Col/Repollo', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza picado', 'serving_weight' => 89, 'calories' => 22, 'proteins' => 1.1, 'carbs' => 5, 'fats' => 0.1, 'fiber' => 2.2],
            ['name' => 'Coliflor', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 107, 'calories' => 27, 'proteins' => 2.1, 'carbs' => 5, 'fats' => 0.3, 'fiber' => 2.1],
            ['name' => 'Coles de Bruselas', 'category' => 'Verduras', 'meal_type' => 'cena', 'serving_size' => '1 taza', 'serving_weight' => 156, 'calories' => 56, 'proteins' => 4, 'carbs' => 11, 'fats' => 0.8, 'fiber' => 4.1],
            ['name' => 'Zanahoria cruda', 'category' => 'Verduras', 'meal_type' => 'merienda', 'serving_size' => '1 mediana', 'serving_weight' => 61, 'calories' => 25, 'proteins' => 0.6, 'carbs' => 6, 'fats' => 0.1, 'fiber' => 1.7],
            ['name' => 'Zanahorias cocidas', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 156, 'calories' => 55, 'proteins' => 1.2, 'carbs' => 13, 'fats' => 0.3, 'fiber' => 4.7],
            ['name' => 'Apio', 'category' => 'Verduras', 'meal_type' => 'merienda', 'serving_size' => '2 tallos', 'serving_weight' => 80, 'calories' => 13, 'proteins' => 0.6, 'carbs' => 2.4, 'fats' => 0.1, 'fiber' => 1.3],
            ['name' => 'Pepino', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1/2 unidad', 'serving_weight' => 150, 'calories' => 23, 'proteins' => 1, 'carbs' => 4.4, 'fats' => 0.2, 'fiber' => 0.8],
            ['name' => 'Tomate', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 mediano', 'serving_weight' => 123, 'calories' => 22, 'proteins' => 1.1, 'carbs' => 4.8, 'fats' => 0.2, 'fiber' => 1.5],
            ['name' => 'Tomates cherry', 'category' => 'Verduras', 'meal_type' => 'merienda', 'serving_size' => '1 taza', 'serving_weight' => 149, 'calories' => 27, 'proteins' => 1.3, 'carbs' => 6, 'fats' => 0.3, 'fiber' => 1.8],
            ['name' => 'Pimiento rojo', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 mediano', 'serving_weight' => 119, 'calories' => 37, 'proteins' => 1.2, 'carbs' => 7, 'fats' => 0.4, 'fiber' => 2.5],
            ['name' => 'Pimiento verde', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 mediano', 'serving_weight' => 119, 'calories' => 24, 'proteins' => 1, 'carbs' => 5.5, 'fats' => 0.2, 'fiber' => 2],
            ['name' => 'Pimiento amarillo', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 mediano', 'serving_weight' => 119, 'calories' => 32, 'proteins' => 1.2, 'carbs' => 7, 'fats' => 0.2, 'fiber' => 1],
            ['name' => 'Cebolla', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1/2 mediana', 'serving_weight' => 55, 'calories' => 22, 'proteins' => 0.6, 'carbs' => 5, 'fats' => 0.1, 'fiber' => 0.9],
            ['name' => 'Ajo', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '3 dientes', 'serving_weight' => 9, 'calories' => 13, 'proteins' => 0.6, 'carbs' => 3, 'fats' => 0, 'fiber' => 0.2],
            ['name' => 'Berenjena', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza cocida', 'serving_weight' => 99, 'calories' => 35, 'proteins' => 0.8, 'carbs' => 9, 'fats' => 0.2, 'fiber' => 2.5],
            ['name' => 'Calabacín/Zucchini', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 113, 'calories' => 19, 'proteins' => 1.4, 'carbs' => 4, 'fats' => 0.2, 'fiber' => 1.1],
            ['name' => 'Calabaza', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza cocida', 'serving_weight' => 245, 'calories' => 49, 'proteins' => 1.8, 'carbs' => 12, 'fats' => 0.2, 'fiber' => 2.7],
            ['name' => 'Espárragos', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '6 tallos', 'serving_weight' => 90, 'calories' => 18, 'proteins' => 2, 'carbs' => 3.5, 'fats' => 0.2, 'fiber' => 1.9],
            ['name' => 'Alcachofas', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 mediana', 'serving_weight' => 128, 'calories' => 60, 'proteins' => 4.2, 'carbs' => 13, 'fats' => 0.2, 'fiber' => 7],
            ['name' => 'Champiñones', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 96, 'calories' => 21, 'proteins' => 3, 'carbs' => 3, 'fats' => 0.3, 'fiber' => 1],
            ['name' => 'Setas Shiitake', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza cocidas', 'serving_weight' => 145, 'calories' => 81, 'proteins' => 2.3, 'carbs' => 21, 'fats' => 0.3, 'fiber' => 3],
            ['name' => 'Judías verdes', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 125, 'calories' => 44, 'proteins' => 2.4, 'carbs' => 10, 'fats' => 0.4, 'fiber' => 4],
            ['name' => 'Rábanos', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 116, 'calories' => 19, 'proteins' => 0.8, 'carbs' => 4, 'fats' => 0.1, 'fiber' => 1.9],
            ['name' => 'Remolacha/Betabel', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza cocida', 'serving_weight' => 170, 'calories' => 75, 'proteins' => 2.9, 'carbs' => 17, 'fats' => 0.3, 'fiber' => 3.4],
            ['name' => 'Puerro', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 taza', 'serving_weight' => 89, 'calories' => 54, 'proteins' => 1.3, 'carbs' => 13, 'fats' => 0.3, 'fiber' => 1.6],
            ['name' => 'Jengibre fresco', 'category' => 'Verduras', 'meal_type' => 'almuerzo', 'serving_size' => '1 cucharada rallado', 'serving_weight' => 6, 'calories' => 5, 'proteins' => 0.1, 'carbs' => 1, 'fats' => 0, 'fiber' => 0.1],

            // GRASAS SALUDABLES - FRUTOS SECOS
            ['name' => 'Almendras', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '1/4 taza (23 unidades)', 'serving_weight' => 28, 'calories' => 164, 'proteins' => 6, 'carbs' => 6, 'fats' => 14, 'fiber' => 3.5],
            ['name' => 'Nueces', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '1/4 taza (7 mitades)', 'serving_weight' => 28, 'calories' => 185, 'proteins' => 4.3, 'carbs' => 4, 'fats' => 18.5, 'fiber' => 1.9],
            ['name' => 'Anacardos/Marañón', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '1/4 taza', 'serving_weight' => 28, 'calories' => 157, 'proteins' => 5, 'carbs' => 9, 'fats' => 12, 'fiber' => 0.9],
            ['name' => 'Maní/Cacahuate', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '1/4 taza', 'serving_weight' => 36, 'calories' => 207, 'proteins' => 9.4, 'carbs' => 6, 'fats' => 18, 'fiber' => 3],
            ['name' => 'Pistachos', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '1/4 taza sin cáscara', 'serving_weight' => 28, 'calories' => 159, 'proteins' => 5.7, 'carbs' => 8, 'fats' => 13, 'fiber' => 2.9],
            ['name' => 'Avellanas', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '1/4 taza', 'serving_weight' => 28, 'calories' => 178, 'proteins' => 4.2, 'carbs' => 5, 'fats' => 17, 'fiber' => 2.7],
            ['name' => 'Nueces de Brasil', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '3 unidades', 'serving_weight' => 15, 'calories' => 99, 'proteins' => 2.2, 'carbs' => 1.4, 'fats' => 10, 'fiber' => 0.8],
            ['name' => 'Nueces de Macadamia', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '5 unidades', 'serving_weight' => 14, 'calories' => 102, 'proteins' => 1.1, 'carbs' => 1.9, 'fats' => 11, 'fiber' => 1.2],
            ['name' => 'Pecanas', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '10 mitades', 'serving_weight' => 14, 'calories' => 97, 'proteins' => 1.3, 'carbs' => 1.9, 'fats' => 10, 'fiber' => 1.3],
            ['name' => 'Piñones', 'category' => 'Grasas Saludables', 'meal_type' => 'almuerzo', 'serving_size' => '2 cucharadas', 'serving_weight' => 20, 'calories' => 135, 'proteins' => 2.7, 'carbs' => 2.6, 'fats' => 14, 'fiber' => 0.7],

            // GRASAS SALUDABLES - SEMILLAS
            ['name' => 'Semillas de Chía', 'category' => 'Grasas Saludables', 'meal_type' => 'desayuno', 'serving_size' => '2 cucharadas', 'serving_weight' => 28, 'calories' => 138, 'proteins' => 4.7, 'carbs' => 12, 'fats' => 8.7, 'fiber' => 9.8],
            ['name' => 'Semillas de Lino/Linaza', 'category' => 'Grasas Saludables', 'meal_type' => 'desayuno', 'serving_size' => '2 cucharadas', 'serving_weight' => 20, 'calories' => 107, 'proteins' => 3.7, 'carbs' => 6, 'fats' => 8.5, 'fiber' => 5.4],
            ['name' => 'Semillas de Calabaza', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '2 cucharadas', 'serving_weight' => 28, 'calories' => 151, 'proteins' => 7, 'carbs' => 5, 'fats' => 13, 'fiber' => 1.7],
            ['name' => 'Semillas de Girasol', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '2 cucharadas', 'serving_weight' => 28, 'calories' => 165, 'proteins' => 5.5, 'carbs' => 7, 'fats' => 14, 'fiber' => 3],
            ['name' => 'Semillas de Sésamo', 'category' => 'Grasas Saludables', 'meal_type' => 'almuerzo', 'serving_size' => '2 cucharadas', 'serving_weight' => 18, 'calories' => 103, 'proteins' => 3.2, 'carbs' => 4, 'fats' => 9, 'fiber' => 2.1],
            ['name' => 'Semillas de Cáñamo', 'category' => 'Grasas Saludables', 'meal_type' => 'desayuno', 'serving_size' => '3 cucharadas', 'serving_weight' => 30, 'calories' => 166, 'proteins' => 9.5, 'carbs' => 2.6, 'fats' => 14.6, 'fiber' => 1.2],

            // GRASAS SALUDABLES - ACEITES Y MANTEQUILLAS
            ['name' => 'Aceite de Oliva', 'category' => 'Grasas Saludables', 'meal_type' => 'almuerzo', 'serving_size' => '1 cucharada', 'serving_weight' => 14, 'calories' => 119, 'proteins' => 0, 'carbs' => 0, 'fats' => 13.5, 'fiber' => 0],
            ['name' => 'Aceite de Coco', 'category' => 'Grasas Saludables', 'meal_type' => 'desayuno', 'serving_size' => '1 cucharada', 'serving_weight' => 14, 'calories' => 121, 'proteins' => 0, 'carbs' => 0, 'fats' => 13.5, 'fiber' => 0],
            ['name' => 'Aceite de Aguacate', 'category' => 'Grasas Saludables', 'meal_type' => 'almuerzo', 'serving_size' => '1 cucharada', 'serving_weight' => 14, 'calories' => 124, 'proteins' => 0, 'carbs' => 0, 'fats' => 14, 'fiber' => 0],
            ['name' => 'Mantequilla', 'category' => 'Grasas Saludables', 'meal_type' => 'desayuno', 'serving_size' => '1 cucharada', 'serving_weight' => 14, 'calories' => 102, 'proteins' => 0.1, 'carbs' => 0, 'fats' => 11.5, 'fiber' => 0],
            ['name' => 'Ghee', 'category' => 'Grasas Saludables', 'meal_type' => 'almuerzo', 'serving_size' => '1 cucharada', 'serving_weight' => 14, 'calories' => 120, 'proteins' => 0, 'carbs' => 0, 'fats' => 14, 'fiber' => 0],
            ['name' => 'Mantequilla de Maní/Cacahuate', 'category' => 'Grasas Saludables', 'meal_type' => 'desayuno', 'serving_size' => '2 cucharadas', 'serving_weight' => 32, 'calories' => 188, 'proteins' => 8, 'carbs' => 6, 'fats' => 16, 'fiber' => 1.9],
            ['name' => 'Mantequilla de Almendra', 'category' => 'Grasas Saludables', 'meal_type' => 'desayuno', 'serving_size' => '2 cucharadas', 'serving_weight' => 32, 'calories' => 196, 'proteins' => 6.7, 'carbs' => 6, 'fats' => 18, 'fiber' => 3.3],
            ['name' => 'Tahini', 'category' => 'Grasas Saludables', 'meal_type' => 'almuerzo', 'serving_size' => '2 cucharadas', 'serving_weight' => 30, 'calories' => 178, 'proteins' => 5, 'carbs' => 6, 'fats' => 16, 'fiber' => 1.4],
            ['name' => 'Aceitunas verdes', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '10 unidades', 'serving_weight' => 40, 'calories' => 46, 'proteins' => 0.4, 'carbs' => 2.5, 'fats' => 4.8, 'fiber' => 1.3],
            ['name' => 'Aceitunas negras', 'category' => 'Grasas Saludables', 'meal_type' => 'merienda', 'serving_size' => '10 unidades', 'serving_weight' => 40, 'calories' => 52, 'proteins' => 0.4, 'carbs' => 2.8, 'fats' => 4.8, 'fiber' => 1.2],

            // SUPLEMENTOS Y PROTEÍNAS
            ['name' => 'Proteína de Suero (Whey)', 'category' => 'Suplementos', 'meal_type' => 'post_workout', 'serving_size' => '1 scoop', 'serving_weight' => 30, 'calories' => 120, 'proteins' => 24, 'carbs' => 3, 'fats' => 1.5, 'fiber' => 0],
            ['name' => 'Proteína de Suero Isolate', 'category' => 'Suplementos', 'meal_type' => 'post_workout', 'serving_size' => '1 scoop', 'serving_weight' => 30, 'calories' => 110, 'proteins' => 25, 'carbs' => 1, 'fats' => 0.5, 'fiber' => 0],
            ['name' => 'Proteína de Caseína', 'category' => 'Suplementos', 'meal_type' => 'cena', 'serving_size' => '1 scoop', 'serving_weight' => 33, 'calories' => 120, 'proteins' => 24, 'carbs' => 3, 'fats' => 1, 'fiber' => 0],
            ['name' => 'Proteína de Guisante', 'category' => 'Suplementos', 'meal_type' => 'post_workout', 'serving_size' => '1 scoop', 'serving_weight' => 33, 'calories' => 120, 'proteins' => 24, 'carbs' => 2, 'fats' => 1.5, 'fiber' => 1],
            ['name' => 'Proteína de Soja', 'category' => 'Suplementos', 'meal_type' => 'post_workout', 'serving_size' => '1 scoop', 'serving_weight' => 30, 'calories' => 110, 'proteins' => 23, 'carbs' => 2, 'fats' => 1, 'fiber' => 0],
            ['name' => 'Proteína de Arroz', 'category' => 'Suplementos', 'meal_type' => 'post_workout', 'serving_size' => '1 scoop', 'serving_weight' => 30, 'calories' => 107, 'proteins' => 22, 'carbs' => 2, 'fats' => 1.5, 'fiber' => 0],
            ['name' => 'Creatina monohidrato', 'category' => 'Suplementos', 'meal_type' => 'post_workout', 'serving_size' => '5g', 'serving_weight' => 5, 'calories' => 0, 'proteins' => 0, 'carbs' => 0, 'fats' => 0, 'fiber' => 0],
            ['name' => 'BCAA (Aminoácidos ramificados)', 'category' => 'Suplementos', 'meal_type' => 'intra_workout', 'serving_size' => '10g', 'serving_weight' => 10, 'calories' => 40, 'proteins' => 10, 'carbs' => 0, 'fats' => 0, 'fiber' => 0],
            ['name' => 'Glutamina', 'category' => 'Suplementos', 'meal_type' => 'post_workout', 'serving_size' => '5g', 'serving_weight' => 5, 'calories' => 20, 'proteins' => 5, 'carbs' => 0, 'fats' => 0, 'fiber' => 0],
            ['name' => 'Pre-entreno estándar', 'category' => 'Suplementos', 'meal_type' => 'pre_workout', 'serving_size' => '1 scoop', 'serving_weight' => 15, 'calories' => 10, 'proteins' => 0, 'carbs' => 2, 'fats' => 0, 'fiber' => 0],

            // BEBIDAS
            ['name' => 'Café negro', 'category' => 'Bebidas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza', 'serving_weight' => 240, 'calories' => 2, 'proteins' => 0.3, 'carbs' => 0, 'fats' => 0, 'fiber' => 0],
            ['name' => 'Té verde', 'category' => 'Bebidas', 'meal_type' => 'merienda', 'serving_size' => '1 taza', 'serving_weight' => 245, 'calories' => 2, 'proteins' => 0, 'carbs' => 0, 'fats' => 0, 'fiber' => 0],
            ['name' => 'Té negro', 'category' => 'Bebidas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza', 'serving_weight' => 245, 'calories' => 2, 'proteins' => 0, 'carbs' => 0.7, 'fats' => 0, 'fiber' => 0],
            ['name' => 'Leche de Almendra sin azúcar', 'category' => 'Bebidas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza', 'serving_weight' => 240, 'calories' => 30, 'proteins' => 1, 'carbs' => 1, 'fats' => 2.5, 'fiber' => 0],
            ['name' => 'Leche de Soja sin azúcar', 'category' => 'Bebidas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza', 'serving_weight' => 240, 'calories' => 80, 'proteins' => 7, 'carbs' => 4, 'fats' => 4, 'fiber' => 1],
            ['name' => 'Leche de Avena', 'category' => 'Bebidas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza', 'serving_weight' => 240, 'calories' => 120, 'proteins' => 3, 'carbs' => 16, 'fats' => 5, 'fiber' => 2],
            ['name' => 'Leche de Coco sin azúcar', 'category' => 'Bebidas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza', 'serving_weight' => 240, 'calories' => 45, 'proteins' => 0, 'carbs' => 1, 'fats' => 4, 'fiber' => 0],
            ['name' => 'Agua de Coco', 'category' => 'Bebidas', 'meal_type' => 'post_workout', 'serving_size' => '1 taza', 'serving_weight' => 240, 'calories' => 46, 'proteins' => 1.7, 'carbs' => 9, 'fats' => 0.5, 'fiber' => 2.6],
            ['name' => 'Jugo de Naranja natural', 'category' => 'Bebidas', 'meal_type' => 'desayuno', 'serving_size' => '1 taza', 'serving_weight' => 248, 'calories' => 112, 'proteins' => 1.7, 'carbs' => 26, 'fats' => 0.5, 'fiber' => 0.5],
            ['name' => 'Batido de proteínas casero', 'category' => 'Bebidas', 'meal_type' => 'post_workout', 'serving_size' => '1 batido', 'serving_weight' => 400, 'calories' => 300, 'proteins' => 30, 'carbs' => 35, 'fats' => 6, 'fiber' => 4],

            // CONDIMENTOS Y SALSAS
            ['name' => 'Salsa de Soja', 'category' => 'Condimentos', 'meal_type' => 'almuerzo', 'serving_size' => '1 cucharada', 'serving_weight' => 16, 'calories' => 9, 'proteins' => 0.9, 'carbs' => 0.8, 'fats' => 0, 'fiber' => 0],
            ['name' => 'Vinagre balsámico', 'category' => 'Condimentos', 'meal_type' => 'almuerzo', 'serving_size' => '1 cucharada', 'serving_weight' => 16, 'calories' => 14, 'proteins' => 0.1, 'carbs' => 2.7, 'fats' => 0, 'fiber' => 0],
            ['name' => 'Mostaza', 'category' => 'Condimentos', 'meal_type' => 'almuerzo', 'serving_size' => '1 cucharada', 'serving_weight' => 15, 'calories' => 10, 'proteins' => 0.6, 'carbs' => 0.8, 'fats' => 0.5, 'fiber' => 0.5],
            ['name' => 'Salsa de tomate/Ketchup', 'category' => 'Condimentos', 'meal_type' => 'almuerzo', 'serving_size' => '1 cucharada', 'serving_weight' => 17, 'calories' => 19, 'proteins' => 0.2, 'carbs' => 4.8, 'fats' => 0, 'fiber' => 0],
            ['name' => 'Mayonesa', 'category' => 'Condimentos', 'meal_type' => 'almuerzo', 'serving_size' => '1 cucharada', 'serving_weight' => 13, 'calories' => 94, 'proteins' => 0.1, 'carbs' => 0, 'fats' => 10, 'fiber' => 0],
            ['name' => 'Mayonesa light', 'category' => 'Condimentos', 'meal_type' => 'almuerzo', 'serving_size' => '1 cucharada', 'serving_weight' => 15, 'calories' => 35, 'proteins' => 0.1, 'carbs' => 2.5, 'fats' => 3, 'fiber' => 0],
            ['name' => 'Guacamole', 'category' => 'Condimentos', 'meal_type' => 'merienda', 'serving_size' => '2 cucharadas', 'serving_weight' => 30, 'calories' => 50, 'proteins' => 0.6, 'carbs' => 3, 'fats' => 4, 'fiber' => 2],
            ['name' => 'Salsa pico de gallo', 'category' => 'Condimentos', 'meal_type' => 'almuerzo', 'serving_size' => '2 cucharadas', 'serving_weight' => 30, 'calories' => 5, 'proteins' => 0.2, 'carbs' => 1, 'fats' => 0, 'fiber' => 0.3],
            ['name' => 'Miel', 'category' => 'Condimentos', 'meal_type' => 'desayuno', 'serving_size' => '1 cucharada', 'serving_weight' => 21, 'calories' => 64, 'proteins' => 0.1, 'carbs' => 17, 'fats' => 0, 'fiber' => 0],
            ['name' => 'Jarabe de arce', 'category' => 'Condimentos', 'meal_type' => 'desayuno', 'serving_size' => '1 cucharada', 'serving_weight' => 20, 'calories' => 52, 'proteins' => 0, 'carbs' => 13, 'fats' => 0, 'fiber' => 0],
            ['name' => 'Stevia', 'category' => 'Condimentos', 'meal_type' => 'desayuno', 'serving_size' => '1 sobre', 'serving_weight' => 1, 'calories' => 0, 'proteins' => 0, 'carbs' => 0, 'fats' => 0, 'fiber' => 0],

            // SNACKS SALUDABLES
            ['name' => 'Chocolate negro 70%', 'category' => 'Snacks', 'meal_type' => 'merienda', 'serving_size' => '2 onzas', 'serving_weight' => 28, 'calories' => 170, 'proteins' => 2.2, 'carbs' => 13, 'fats' => 12, 'fiber' => 3],
            ['name' => 'Chocolate negro 85%', 'category' => 'Snacks', 'meal_type' => 'merienda', 'serving_size' => '2 onzas', 'serving_weight' => 28, 'calories' => 170, 'proteins' => 2.8, 'carbs' => 10, 'fats' => 14, 'fiber' => 4],
            ['name' => 'Palomitas de maíz (sin mantequilla)', 'category' => 'Snacks', 'meal_type' => 'merienda', 'serving_size' => '3 tazas', 'serving_weight' => 24, 'calories' => 93, 'proteins' => 3, 'carbs' => 19, 'fats' => 1, 'fiber' => 3.5],
            ['name' => 'Barritas de proteína', 'category' => 'Snacks', 'meal_type' => 'merienda', 'serving_size' => '1 barra', 'serving_weight' => 60, 'calories' => 200, 'proteins' => 20, 'carbs' => 22, 'fats' => 6, 'fiber' => 5],
            ['name' => 'Barritas de granola', 'category' => 'Snacks', 'meal_type' => 'merienda', 'serving_size' => '1 barra', 'serving_weight' => 35, 'calories' => 140, 'proteins' => 3, 'carbs' => 26, 'fats' => 4, 'fiber' => 2],
            ['name' => 'Mix de frutos secos', 'category' => 'Snacks', 'meal_type' => 'merienda', 'serving_size' => '1/4 taza', 'serving_weight' => 35, 'calories' => 175, 'proteins' => 5, 'carbs' => 15, 'fats' => 12, 'fiber' => 2],
            ['name' => 'Galletas de avena caseras', 'category' => 'Snacks', 'meal_type' => 'merienda', 'serving_size' => '2 unidades', 'serving_weight' => 40, 'calories' => 140, 'proteins' => 3, 'carbs' => 22, 'fats' => 5, 'fiber' => 2],
            ['name' => 'Chips de kale', 'category' => 'Snacks', 'meal_type' => 'merienda', 'serving_size' => '1 taza', 'serving_weight' => 25, 'calories' => 50, 'proteins' => 3, 'carbs' => 6, 'fats' => 2, 'fiber' => 1],
            ['name' => 'Edamame con sal', 'category' => 'Snacks', 'meal_type' => 'merienda', 'serving_size' => '1/2 taza', 'serving_weight' => 75, 'calories' => 95, 'proteins' => 9, 'carbs' => 7, 'fats' => 4, 'fiber' => 4],
            ['name' => 'Croquetas de quinoa', 'category' => 'Snacks', 'meal_type' => 'merienda', 'serving_size' => '3 unidades', 'serving_weight' => 60, 'calories' => 120, 'proteins' => 4, 'carbs' => 18, 'fats' => 4, 'fiber' => 2],
        ];

        // Limpiar alimentos globales existentes (no personalizados) para evitar duplicados
        Food::where('is_custom', false)->delete();

        foreach ($foods as $food) {
            Food::create([
                'name' => $food['name'],
                'category' => $food['category'],
                'meal_type' => $food['meal_type'],
                'serving_size' => $food['serving_size'],
                'serving_weight' => $food['serving_weight'],
                'calories' => $food['calories'],
                'proteins' => $food['proteins'],
                'carbs' => $food['carbs'],
                'fats' => $food['fats'],
                'fiber' => $food['fiber'],
                'is_custom' => false,
                'is_active' => true,
                'user_id' => null,
            ]);
        }
    }
}
