<?php

namespace Database\Seeders;

use App\Models\Food;
use App\Models\MealItem;
use App\Models\MealPlan;
use App\Models\Workout;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AdditionalOfficialTemplatesSeeder extends Seeder
{
    public function run(): void
    {
        $this->seedWorkoutTemplates();
        $this->seedMealPlanTemplates();
    }

    private function seedWorkoutTemplates(): void
    {
        $templates = [
            // ============================================================
            // 6. HIIT CARDIO QUEMAGRASA - 3 DÍAS
            // ============================================================
            [
                'name' => 'HIIT Cardio Quemagrasa - 3 Días',
                'description' => 'Programa de intervalos de alta intensidad de 3 días para maximizar la quema de grasa. Combina ejercicios compuestos con mínimo descanso para elevar el metabolismo.',
                'type' => 'hiit',
                'duration_weeks' => 6,
                'days' => [
                    [
                        'name' => 'Día 1 - HIIT Tren Superior',
                        'exercises' => [
                            ['name' => 'Burpees', 'muscle_group' => 'cuerpo_completo', 'sets' => 4, 'reps' => '12-15', 'rest' => '30', 'rest_seconds' => 30, 'notes' => '30 seg de descanso entre series. Explosivo al saltar.', 'block_name' => 'Circuito A', 'order' => 0],
                            ['name' => 'Mountain climbers', 'muscle_group' => 'abdominales', 'sets' => 4, 'reps' => '30 seg', 'rest' => '20', 'rest_seconds' => 20, 'notes' => 'Rodillas al pecho alternando, velocidad máxima.', 'block_name' => 'Circuito A', 'order' => 1],
                            ['name' => 'Flexiones de brazos', 'muscle_group' => 'pecho', 'sets' => 4, 'reps' => '15-20', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Pecho casi toca el suelo, ritmo controlado.', 'block_name' => 'Circuito A', 'order' => 2],
                            ['name' => 'Jumping jacks', 'muscle_group' => 'cuerpo_completo', 'sets' => 4, 'reps' => '45 seg', 'rest' => '15', 'rest_seconds' => 15, 'notes' => 'Mantener intensidad alta durante todo el intervalo.', 'block_name' => 'Circuito B', 'order' => 3],
                            ['name' => 'Press militar con mancuernas', 'muscle_group' => 'hombros', 'sets' => 3, 'reps' => '12-15', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Peso moderado, ritmo rápido pero controlado.', 'block_name' => 'Circuito B', 'order' => 4],
                            ['name' => 'Plancha abdominal', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '45-60 seg', 'rest' => '20', 'rest_seconds' => 20, 'notes' => 'Core contraído, caderas alineadas con hombros.', 'block_name' => 'Finisher', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 2 - HIIT Tren Inferior',
                        'exercises' => [
                            ['name' => 'Sentadilla con salto', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '15', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Explosión al saltar, aterrizar suave con rodillas flexionadas.', 'block_name' => 'Circuito A', 'order' => 0],
                            ['name' => 'Zancadas con salto alternas', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '12 cada pierna', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Alternar piernas en el aire. Rodilla trasera casi toca el suelo.', 'block_name' => 'Circuito A', 'order' => 1],
                            ['name' => 'Hip thrust con barra', 'muscle_group' => 'glúteos', 'sets' => 4, 'reps' => '15-20', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Peso moderado, ritmo rápido. Apretar glúteos arriba.', 'block_name' => 'Circuito A', 'order' => 2],
                            ['name' => 'Box jumps', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '12', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Cajón a la altura de la rodilla. Aterrizar con ambos pies.', 'block_name' => 'Circuito B', 'order' => 3],
                            ['name' => 'Elevaciones de pantorrillas', 'muscle_group' => 'pantorrillas', 'sets' => 3, 'reps' => '20-25', 'rest' => '20', 'rest_seconds' => 20, 'notes' => 'Rango completo, ritmo rápido con pausa arriba.', 'block_name' => 'Circuito B', 'order' => 4],
                            ['name' => 'Sprints en el sitio', 'muscle_group' => 'cuerpo_completo', 'sets' => 4, 'reps' => '30 seg', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Rodillas altas, máxima velocidad posible. Finisher.', 'block_name' => 'Finisher', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 3 - HIIT Full Body',
                        'exercises' => [
                            ['name' => 'Burpees', 'muscle_group' => 'cuerpo_completo', 'sets' => 5, 'reps' => '10', 'rest' => '20', 'rest_seconds' => 20, 'notes' => 'Circuito EMOM: completar en menos de 40 seg, descansar el resto.', 'block_name' => 'EMOM', 'order' => 0],
                            ['name' => 'Sentadilla con barra', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '12', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Peso al 60% del máximo, velocidad controlada.', 'block_name' => 'Fuerza Rápida', 'order' => 1],
                            ['name' => 'Remo con barra', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '12', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Peso moderado, apretar escápulas rápido.', 'block_name' => 'Fuerza Rápida', 'order' => 2],
                            ['name' => 'Flexiones de brazos', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => 'máximas', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Series al fallo, entonces descansar 30 seg.', 'block_name' => 'Fatiga', 'order' => 3],
                            ['name' => 'Sentadilla con salto', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '15', 'rest' => '20', 'rest_seconds' => 20, 'notes' => 'Sin peso, máxima explosividad.', 'block_name' => 'Fatiga', 'order' => 4],
                            ['name' => 'Plancha abdominal', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '60 seg', 'rest' => '15', 'rest_seconds' => 15, 'notes' => 'Terminar con core fuerte. Aguantar posición.', 'block_name' => 'Core', 'order' => 5],
                        ],
                    ],
                ],
            ],

            // ============================================================
            // 7. CALISTENIA - PESO CORPORAL - 4 DÍAS
            // ============================================================
            [
                'name' => 'Calistenia - Peso Corporal 4 Días',
                'description' => 'Programa completo de calistenia sin necesidad de equipamiento de gimnasio. Progresiones de peso corporal para fuerza y control muscular.',
                'type' => 'calistenia',
                'duration_weeks' => 8,
                'days' => [
                    [
                        'name' => 'Día 1 - Push (Empuje)',
                        'exercises' => [
                            ['name' => 'Flexiones diamante', 'muscle_group' => 'tríceps', 'sets' => 4, 'reps' => '10-15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Manos juntas formando un diamante. Codos cerca del cuerpo.', 'block_name' => 'Principal', 'order' => 0],
                            ['name' => 'Flexiones de brazos', 'muscle_group' => 'pecho', 'sets' => 4, 'reps' => '15-20', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Rango completo, bajar pecho al suelo. Si es fácil, elevar pies.', 'block_name' => 'Principal', 'order' => 1],
                            ['name' => 'Fondos en paralelas', 'muscle_group' => 'pecho', 'sets' => 4, 'reps' => '8-12', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Inclinarse adelante para pecho, recto para tríceps. Sin balanceo.', 'block_name' => 'Principal', 'order' => 2],
                            ['name' => 'Pike push-ups', 'muscle_group' => 'hombros', 'sets' => 3, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Cadera arriba formando V invertida. Progresión hacia handstand push-up.', 'block_name' => 'Accesorio', 'order' => 3],
                            ['name' => 'Flexiones con palmada', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '8-10', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Explosivo. Si no puedes, hacer flexiones rápidas normales.', 'block_name' => 'Pliométrico', 'order' => 4],
                            ['name' => 'Plancha abdominal', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '45-60 seg', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Core completamente contraído. No dejar caer caderas.', 'block_name' => 'Core', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 2 - Pull (Tirón)',
                        'exercises' => [
                            ['name' => 'Dominadas pronación', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '6-10', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Agarre prono, ancho de hombros o más. Barbilla sobre la barra.', 'block_name' => 'Principal', 'order' => 0],
                            ['name' => 'Dominadas supinación', 'muscle_group' => 'bíceps', 'sets' => 4, 'reps' => '8-10', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Agarre supino (palmas hacia ti). Trabaja más bíceps.', 'block_name' => 'Principal', 'order' => 1],
                            ['name' => 'Remo invertido', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '12-15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'En barra baja. Cuerpo recto, tirar pecho a la barra.', 'block_name' => 'Accesorio', 'order' => 2],
                            ['name' => 'Curl isométrico en barra', 'muscle_group' => 'bíceps', 'sets' => 3, 'reps' => '20-30 seg', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Mantener la posición de dominada a 90° sin moverse.', 'block_name' => 'Isométrico', 'order' => 3],
                            ['name' => 'Colgarse de barra (dead hang)', 'muscle_group' => 'antebrazos', 'sets' => 3, 'reps' => '30-45 seg', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Agarre activo, hombros bajados. Fortalece agarre.', 'block_name' => 'Accesorio', 'order' => 4],
                            ['name' => 'Elevación de piernas colgando', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '10-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Piernas rectas. Si no puedes, flexiona rodillas.', 'block_name' => 'Core', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 3 - Piernas',
                        'exercises' => [
                            ['name' => 'Sentadilla pistol (una pierna)', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '5-8 c/pierna', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Progresión: usar apoyo si necesario. Una pierna extendida al frente.', 'block_name' => 'Principal', 'order' => 0],
                            ['name' => 'Sentadilla búlgara sin peso', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '12-15 c/pierna', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Pie trasero en banco. Torso erguido, rodilla sobre el pie.', 'block_name' => 'Principal', 'order' => 1],
                            ['name' => 'Puente de glúteos a una pierna', 'muscle_group' => 'glúteos', 'sets' => 4, 'reps' => '12-15 c/pierna', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Una pierna extendida, empujar con el talón. Apretar 2 seg arriba.', 'block_name' => 'Accesorio', 'order' => 2],
                            ['name' => 'Nordic curl (excéntrico)', 'muscle_group' => 'isquiotibiales', 'sets' => 3, 'reps' => '5-8', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Bajar lo más lento posible. Usar manos para ayudar a subir.', 'block_name' => 'Accesorio', 'order' => 3],
                            ['name' => 'Elevaciones de pantorrillas a una pierna', 'muscle_group' => 'pantorrillas', 'sets' => 4, 'reps' => '15-20 c/pierna', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'En borde de escalón para rango completo.', 'block_name' => 'Aislamiento', 'order' => 4],
                            ['name' => 'Sentadilla isométrica (wall sit)', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '45-60 seg', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Espalda contra la pared, muslos paralelos al suelo.', 'block_name' => 'Finisher', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 4 - Full Body Core',
                        'exercises' => [
                            ['name' => 'Muscle-ups o dominadas explosivas', 'muscle_group' => 'cuerpo_completo', 'sets' => 4, 'reps' => '3-5', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'Si no puedes muscle-up, hacer dominadas bien altas con tirón explosivo.', 'block_name' => 'Avanzado', 'order' => 0],
                            ['name' => 'Fondos en paralelas', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '10-15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Si es fácil, añadir lastre con un cinturón.', 'block_name' => 'Compuesto', 'order' => 1],
                            ['name' => 'Sentadilla con salto', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Explosividad máxima, aterrizar suave.', 'block_name' => 'Pliométrico', 'order' => 2],
                            ['name' => 'L-sit en paralelas', 'muscle_group' => 'abdominales', 'sets' => 4, 'reps' => '15-20 seg', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Piernas rectas, paralelas al suelo. Si no puedes, rodillas flexionadas.', 'block_name' => 'Core', 'order' => 3],
                            ['name' => 'Plancha lateral', 'muscle_group' => 'oblicuos', 'sets' => 3, 'reps' => '30 seg c/lado', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Cuerpo en línea recta, cadera elevada.', 'block_name' => 'Core', 'order' => 4],
                            ['name' => 'Superman hold', 'muscle_group' => 'espalda', 'sets' => 3, 'reps' => '30 seg', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Boca abajo, levantar brazos y piernas. Apretar espalda baja.', 'block_name' => 'Core', 'order' => 5],
                        ],
                    ],
                ],
            ],

            // ============================================================
            // 8. POWERLIFTING - FUERZA MÁXIMA 4 DÍAS
            // ============================================================
            [
                'name' => 'Powerlifting - Fuerza Máxima 4 Días',
                'description' => 'Programa enfocado en los 3 grandes levantamientos: sentadilla, press de banca y peso muerto. Periodización ondulante para desarrollar fuerza máxima.',
                'type' => 'fuerza',
                'duration_weeks' => 12,
                'days' => [
                    [
                        'name' => 'Día 1 - Sentadilla (Pesado)',
                        'exercises' => [
                            ['name' => 'Sentadilla con barra', 'muscle_group' => 'cuádriceps', 'sets' => 5, 'reps' => '3-5', 'rest' => '240', 'rest_seconds' => 240, 'notes' => 'RPE 8-9. Semana 1: 80%, S2: 82.5%, S3: 85%, S4: deload 70%.', 'block_name' => 'Principal', 'order' => 0],
                            ['name' => 'Sentadilla con pausa', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '3', 'rest' => '180', 'rest_seconds' => 180, 'notes' => 'Pausa de 3 seg en el punto más bajo. 70% del máximo.', 'block_name' => 'Variación', 'order' => 1],
                            ['name' => 'Prensa de piernas', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '8-10', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'Trabajo complementario de cuádriceps.', 'block_name' => 'Accesorio', 'order' => 2],
                            ['name' => 'Buenos días con barra', 'muscle_group' => 'isquiotibiales', 'sets' => 3, 'reps' => '8-10', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Fortalece cadena posterior para mejorar sentadilla.', 'block_name' => 'Accesorio', 'order' => 3],
                            ['name' => 'Extensiones de cuádriceps', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '12-15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Aislamiento de cuádriceps. Extensión completa.', 'block_name' => 'Aislamiento', 'order' => 4],
                            ['name' => 'Plancha abdominal', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '60 seg', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Core fuerte = sentadilla fuerte.', 'block_name' => 'Core', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 2 - Press Banca (Pesado)',
                        'exercises' => [
                            ['name' => 'Press de banca con barra', 'muscle_group' => 'pecho', 'sets' => 5, 'reps' => '3-5', 'rest' => '240', 'rest_seconds' => 240, 'notes' => 'RPE 8-9. Retracción escapular, arco lumbar moderado.', 'block_name' => 'Principal', 'order' => 0],
                            ['name' => 'Press de banca agarre cerrado', 'muscle_group' => 'tríceps', 'sets' => 3, 'reps' => '6-8', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'Agarre al ancho de hombros. Trabaja tríceps para mejorar lockout.', 'block_name' => 'Variación', 'order' => 1],
                            ['name' => 'Press inclinado con mancuernas', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '8-10', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Desarrollo del pecho superior.', 'block_name' => 'Accesorio', 'order' => 2],
                            ['name' => 'Remo con barra', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '8-10', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Balance muscular. Espalda fuerte = press fuerte.', 'block_name' => 'Accesorio', 'order' => 3],
                            ['name' => 'Press francés con barra Z', 'muscle_group' => 'tríceps', 'sets' => 3, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Fortalece el lockout del press de banca.', 'block_name' => 'Aislamiento', 'order' => 4],
                            ['name' => 'Face pulls', 'muscle_group' => 'hombros', 'sets' => 3, 'reps' => '15-20', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Salud de hombros. Esencial en powerlifting.', 'block_name' => 'Prehab', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 3 - Peso Muerto (Pesado)',
                        'exercises' => [
                            ['name' => 'Peso muerto convencional', 'muscle_group' => 'espalda', 'sets' => 5, 'reps' => '2-4', 'rest' => '300', 'rest_seconds' => 300, 'notes' => 'RPE 8-9. Forma perfecta siempre. No sacrificar técnica por peso.', 'block_name' => 'Principal', 'order' => 0],
                            ['name' => 'Peso muerto en déficit', 'muscle_group' => 'espalda', 'sets' => 3, 'reps' => '5-6', 'rest' => '180', 'rest_seconds' => 180, 'notes' => 'De pie sobre plataforma de 5cm. Mejora el arranque desde el suelo.', 'block_name' => 'Variación', 'order' => 1],
                            ['name' => 'Hip thrust con barra', 'muscle_group' => 'glúteos', 'sets' => 3, 'reps' => '10-12', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Fortalece extensión de cadera para el peso muerto.', 'block_name' => 'Accesorio', 'order' => 2],
                            ['name' => 'Curl de piernas acostado', 'muscle_group' => 'isquiotibiales', 'sets' => 3, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Fortalece isquios como estabilizadores.', 'block_name' => 'Accesorio', 'order' => 3],
                            ['name' => 'Encogimientos con barra', 'muscle_group' => 'trapecios', 'sets' => 3, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Barra frente al cuerpo. Agarre fuerte.', 'block_name' => 'Accesorio', 'order' => 4],
                            ['name' => 'Farmer walks', 'muscle_group' => 'antebrazos', 'sets' => 3, 'reps' => '30 metros', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Mancuernas pesadas, caminar recto. Fortalece agarre.', 'block_name' => 'Grip', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 4 - Volumen (Repeticiones)',
                        'exercises' => [
                            ['name' => 'Sentadilla con barra', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '8-10', 'rest' => '120', 'rest_seconds' => 120, 'notes' => '65-70% del máximo. Trabajo de volumen.', 'block_name' => 'Volumen', 'order' => 0],
                            ['name' => 'Press de banca con barra', 'muscle_group' => 'pecho', 'sets' => 4, 'reps' => '8-10', 'rest' => '120', 'rest_seconds' => 120, 'notes' => '65-70% del máximo. Técnica perfecta.', 'block_name' => 'Volumen', 'order' => 1],
                            ['name' => 'Peso muerto rumano', 'muscle_group' => 'isquiotibiales', 'sets' => 3, 'reps' => '10-12', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Trabajo complementario al peso muerto convencional.', 'block_name' => 'Volumen', 'order' => 2],
                            ['name' => 'Press militar con barra', 'muscle_group' => 'hombros', 'sets' => 3, 'reps' => '8-10', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Fortalece hombros para el press de banca.', 'block_name' => 'Accesorio', 'order' => 3],
                            ['name' => 'Dominadas o jalón al pecho', 'muscle_group' => 'espalda', 'sets' => 3, 'reps' => '8-10', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Balance de espalda. Agarre prono.', 'block_name' => 'Accesorio', 'order' => 4],
                            ['name' => 'Curl con barra', 'muscle_group' => 'bíceps', 'sets' => 3, 'reps' => '10-12', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Trabajo complementario de brazos.', 'block_name' => 'Aislamiento', 'order' => 5],
                        ],
                    ],
                ],
            ],

            // ============================================================
            // 9. FUNCIONAL / CROSSFIT STYLE - 5 DÍAS
            // ============================================================
            [
                'name' => 'Funcional CrossFit Style - 5 Días',
                'description' => 'Programa funcional de 5 días inspirado en CrossFit. Combina fuerza, gymnastics y acondicionamiento metabólico para una condición física completa.',
                'type' => 'funcional',
                'duration_weeks' => 8,
                'days' => [
                    [
                        'name' => 'Día 1 - Fuerza + Metcon',
                        'exercises' => [
                            ['name' => 'Sentadilla con barra', 'muscle_group' => 'cuádriceps', 'sets' => 5, 'reps' => '5', 'rest' => '150', 'rest_seconds' => 150, 'notes' => 'Fuerza pesada. Aumentar peso cada semana.', 'block_name' => 'Fuerza', 'order' => 0],
                            ['name' => 'Press militar con barra', 'muscle_group' => 'hombros', 'sets' => 5, 'reps' => '5', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'De pie, strict press. Sin impulso de piernas.', 'block_name' => 'Fuerza', 'order' => 1],
                            ['name' => 'Burpees', 'muscle_group' => 'cuerpo_completo', 'sets' => 3, 'reps' => '15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Metcon: completar 3 rondas lo más rápido posible.', 'block_name' => 'Metcon', 'order' => 2],
                            ['name' => 'Sentadilla con salto', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Parte del metcon, sin pausa entre ejercicios.', 'block_name' => 'Metcon', 'order' => 3],
                            ['name' => 'Flexiones de brazos', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '20', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Parte del metcon. Completar sin parar.', 'block_name' => 'Metcon', 'order' => 4],
                        ],
                    ],
                    [
                        'name' => 'Día 2 - Gymnastics + Cardio',
                        'exercises' => [
                            ['name' => 'Dominadas pronación', 'muscle_group' => 'espalda', 'sets' => 5, 'reps' => '5-8', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Kipping permitido o strict. Mejorar cada semana.', 'block_name' => 'Skill', 'order' => 0],
                            ['name' => 'Handstand hold (pino)', 'muscle_group' => 'hombros', 'sets' => 5, 'reps' => '20-30 seg', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Contra la pared. Cuerpo recto, core activo.', 'block_name' => 'Skill', 'order' => 1],
                            ['name' => 'Remo con barra', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '10', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Peso moderado, ritmo constante.', 'block_name' => 'Fuerza', 'order' => 2],
                            ['name' => 'Mountain climbers', 'muscle_group' => 'abdominales', 'sets' => 4, 'reps' => '40 seg', 'rest' => '20', 'rest_seconds' => 20, 'notes' => 'Cardio intenso. Rodillas al pecho rápido.', 'block_name' => 'Cardio', 'order' => 3],
                            ['name' => 'Plancha abdominal', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '60 seg', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Terminar con core. Posición perfecta.', 'block_name' => 'Core', 'order' => 4],
                        ],
                    ],
                    [
                        'name' => 'Día 3 - Olympic Lifts + Metcon',
                        'exercises' => [
                            ['name' => 'Peso muerto convencional', 'muscle_group' => 'espalda', 'sets' => 5, 'reps' => '3', 'rest' => '180', 'rest_seconds' => 180, 'notes' => 'Pesado. Forma perfecta en cada rep.', 'block_name' => 'Fuerza', 'order' => 0],
                            ['name' => 'Sentadilla con barra (frontal)', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '5', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'Barra en posición frontal sobre delts. Codos altos.', 'block_name' => 'Fuerza', 'order' => 1],
                            ['name' => 'Box jumps', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '12', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Cajón alto. Aterrizar con ambos pies.', 'block_name' => 'Metcon', 'order' => 2],
                            ['name' => 'Zancadas caminando', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '20 total', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Con mancuernas. Pasos largos y controlados.', 'block_name' => 'Metcon', 'order' => 3],
                            ['name' => 'Elevación de piernas colgando', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Toes to bar si puedes, sino rodillas al pecho.', 'block_name' => 'Core', 'order' => 4],
                        ],
                    ],
                    [
                        'name' => 'Día 4 - Upper Body Pump',
                        'exercises' => [
                            ['name' => 'Press de banca con barra', 'muscle_group' => 'pecho', 'sets' => 5, 'reps' => '5', 'rest' => '150', 'rest_seconds' => 150, 'notes' => 'Pesado. Aumentar peso progresivamente.', 'block_name' => 'Fuerza', 'order' => 0],
                            ['name' => 'Dominadas o jalón al pecho', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '8-10', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Superset con press si el tiempo lo permite.', 'block_name' => 'Fuerza', 'order' => 1],
                            ['name' => 'Fondos en paralelas', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '10-15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Con peso adicional si es posible.', 'block_name' => 'Accesorio', 'order' => 2],
                            ['name' => 'Curl con barra', 'muscle_group' => 'bíceps', 'sets' => 3, 'reps' => '12', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Superset con extensiones de tríceps.', 'block_name' => 'Pump', 'order' => 3],
                            ['name' => 'Extensiones de tríceps en polea', 'muscle_group' => 'tríceps', 'sets' => 3, 'reps' => '12', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Superset con curl de bíceps.', 'block_name' => 'Pump', 'order' => 4],
                        ],
                    ],
                    [
                        'name' => 'Día 5 - Hero WOD (Completo)',
                        'exercises' => [
                            ['name' => 'Burpees', 'muscle_group' => 'cuerpo_completo', 'sets' => 1, 'reps' => '50', 'rest' => '0', 'rest_seconds' => 0, 'notes' => 'AMRAP 20 min: Completar el circuito tantas rondas como puedas.', 'block_name' => 'Hero WOD', 'order' => 0],
                            ['name' => 'Sentadilla con barra', 'muscle_group' => 'cuádriceps', 'sets' => 1, 'reps' => '30', 'rest' => '0', 'rest_seconds' => 0, 'notes' => 'Peso al 50% del máximo. Parte del circuito.', 'block_name' => 'Hero WOD', 'order' => 1],
                            ['name' => 'Dominadas pronación', 'muscle_group' => 'espalda', 'sets' => 1, 'reps' => '20', 'rest' => '0', 'rest_seconds' => 0, 'notes' => 'Kipping o strict. Parte del circuito.', 'block_name' => 'Hero WOD', 'order' => 2],
                            ['name' => 'Flexiones de brazos', 'muscle_group' => 'pecho', 'sets' => 1, 'reps' => '40', 'rest' => '0', 'rest_seconds' => 0, 'notes' => 'Parte del circuito. Distribuir como necesites.', 'block_name' => 'Hero WOD', 'order' => 3],
                            ['name' => 'Plancha abdominal', 'muscle_group' => 'abdominales', 'sets' => 1, 'reps' => '60 seg', 'rest' => '0', 'rest_seconds' => 0, 'notes' => 'Finalizador del circuito. Luego volver al inicio.', 'block_name' => 'Hero WOD', 'order' => 4],
                        ],
                    ],
                ],
            ],

            // ============================================================
            // 10. DEFINICIÓN Y TONIFICACIÓN - 5 DÍAS
            // ============================================================
            [
                'name' => 'Definición y Tonificación - 5 Días',
                'description' => 'Programa de 5 días enfocado en definición muscular. Alto volumen, poco descanso, y combinación de fuerza con cardio para maximizar la quema calórica preservando músculo.',
                'type' => 'hipertrofia',
                'duration_weeks' => 8,
                'days' => [
                    [
                        'name' => 'Día 1 - Pecho y Tríceps',
                        'exercises' => [
                            ['name' => 'Press inclinado con mancuernas', 'muscle_group' => 'pecho', 'sets' => 4, 'reps' => '12-15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Peso moderado, contractión completa. Tempo 3-1-1.', 'block_name' => 'Compuesto', 'order' => 0],
                            ['name' => 'Press de banca con barra', 'muscle_group' => 'pecho', 'sets' => 4, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Controlada, sin rebote. Sentir el pecho.', 'block_name' => 'Compuesto', 'order' => 1],
                            ['name' => 'Aperturas con mancuernas', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Arco amplio, peso ligero. Squeeze al centro.', 'block_name' => 'Aislamiento', 'order' => 2],
                            ['name' => 'Cruces en polea alta', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Cruzar las manos al frente, apretar 2 seg.', 'block_name' => 'Aislamiento', 'order' => 3],
                            ['name' => 'Extensiones de tríceps en polea', 'muscle_group' => 'tríceps', 'sets' => 4, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Cuerda, extensión completa. Codos fijos.', 'block_name' => 'Tríceps', 'order' => 4],
                            ['name' => 'Fondos en paralelas', 'muscle_group' => 'tríceps', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Recto para énfasis en tríceps. Peso corporal.', 'block_name' => 'Tríceps', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 2 - Espalda y Bíceps',
                        'exercises' => [
                            ['name' => 'Dominadas o jalón al pecho', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Agarre ancho, llevar a la clavícula. Squeeze escápulas.', 'block_name' => 'Compuesto', 'order' => 0],
                            ['name' => 'Remo con mancuerna a una mano', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Tirar hacia la cadera. Control excéntrico.', 'block_name' => 'Compuesto', 'order' => 1],
                            ['name' => 'Remo en polea baja sentado', 'muscle_group' => 'espalda', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Agarre cerrado. Abrir pecho, escápulas juntas.', 'block_name' => 'Accesorio', 'order' => 2],
                            ['name' => 'Pullover con mancuerna', 'muscle_group' => 'espalda', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Estiramiento profundo de dorsales.', 'block_name' => 'Accesorio', 'order' => 3],
                            ['name' => 'Curl con barra', 'muscle_group' => 'bíceps', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Sin balanceo. Contracción completa.', 'block_name' => 'Bíceps', 'order' => 4],
                            ['name' => 'Curl martillo', 'muscle_group' => 'bíceps', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Agarre neutro alternado. Braquiorradial + bíceps.', 'block_name' => 'Bíceps', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 3 - Piernas (Cuádriceps)',
                        'exercises' => [
                            ['name' => 'Sentadilla con barra', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '12-15', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Peso moderado, control total. Profundidad completa.', 'block_name' => 'Compuesto', 'order' => 0],
                            ['name' => 'Prensa de piernas', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '12-15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Pies al ancho de hombros, posición baja.', 'block_name' => 'Compuesto', 'order' => 1],
                            ['name' => 'Extensiones de cuádriceps', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '15-20', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Apretar arriba 2 seg. Peso moderado.', 'block_name' => 'Aislamiento', 'order' => 2],
                            ['name' => 'Zancadas caminando', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '15 c/pierna', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Con mancuernas. Pasos largos.', 'block_name' => 'Funcional', 'order' => 3],
                            ['name' => 'Elevaciones de pantorrillas', 'muscle_group' => 'pantorrillas', 'sets' => 4, 'reps' => '20', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Rango completo, pausa arriba y abajo.', 'block_name' => 'Aislamiento', 'order' => 4],
                            ['name' => 'Crunch abdominal', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '20-25', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Elevar escápulas, no tirar del cuello.', 'block_name' => 'Core', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 4 - Hombros y Core',
                        'exercises' => [
                            ['name' => 'Press Arnold', 'muscle_group' => 'hombros', 'sets' => 4, 'reps' => '12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Rotación completa. Trabaja los 3 haces del deltoides.', 'block_name' => 'Compuesto', 'order' => 0],
                            ['name' => 'Elevaciones laterales', 'muscle_group' => 'hombros', 'sets' => 4, 'reps' => '15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Peso ligero, tensión constante. No subir de más.', 'block_name' => 'Aislamiento', 'order' => 1],
                            ['name' => 'Elevaciones frontales', 'muscle_group' => 'hombros', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Alternando con mancuernas. Hasta la altura del hombro.', 'block_name' => 'Aislamiento', 'order' => 2],
                            ['name' => 'Face pulls', 'muscle_group' => 'hombros', 'sets' => 3, 'reps' => '15-20', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Polea alta, cuerda. Rotación externa al final.', 'block_name' => 'Posterior', 'order' => 3],
                            ['name' => 'Plancha abdominal', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '60 seg', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Cuerpo en línea recta, no dejar caer caderas.', 'block_name' => 'Core', 'order' => 4],
                            ['name' => 'Elevación de piernas colgando', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Piernas rectas hasta 90°. Sin balanceo.', 'block_name' => 'Core', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 5 - Glúteos e Isquios',
                        'exercises' => [
                            ['name' => 'Hip thrust con barra', 'muscle_group' => 'glúteos', 'sets' => 4, 'reps' => '12-15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Apretar glúteos 2 seg arriba. Peso moderado-alto.', 'block_name' => 'Principal', 'order' => 0],
                            ['name' => 'Peso muerto rumano', 'muscle_group' => 'isquiotibiales', 'sets' => 4, 'reps' => '12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Estiramiento profundo de isquios. Espalda neutra.', 'block_name' => 'Principal', 'order' => 1],
                            ['name' => 'Sentadilla búlgara', 'muscle_group' => 'glúteos', 'sets' => 3, 'reps' => '12 c/pierna', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Inclinarse ligeramente adelante para activar glúteos.', 'block_name' => 'Accesorio', 'order' => 2],
                            ['name' => 'Curl de piernas acostado', 'muscle_group' => 'isquiotibiales', 'sets' => 3, 'reps' => '15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Flexión completa, control excéntrico 3 seg.', 'block_name' => 'Aislamiento', 'order' => 3],
                            ['name' => 'Abducción de cadera en máquina', 'muscle_group' => 'glúteos', 'sets' => 3, 'reps' => '20', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Inclinarse adelante para glúteo medio.', 'block_name' => 'Aislamiento', 'order' => 4],
                            ['name' => 'Puente de glúteos con banda', 'muscle_group' => 'glúteos', 'sets' => 3, 'reps' => '25', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Banda en rodillas. Abrir al subir. Pumping.', 'block_name' => 'Finisher', 'order' => 5],
                        ],
                    ],
                ],
            ],

            // ============================================================
            // 11. MOVILIDAD Y FLEXIBILIDAD - 3 DÍAS
            // ============================================================
            [
                'name' => 'Movilidad y Flexibilidad - 3 Días',
                'description' => 'Programa de 3 días enfocado en mejorar la movilidad articular, flexibilidad y recuperación activa. Ideal como complemento o para personas con poca movilidad.',
                'type' => 'flexibility',
                'duration_weeks' => 8,
                'days' => [
                    [
                        'name' => 'Día 1 - Tren Superior',
                        'exercises' => [
                            ['name' => 'Dislocaciones de hombro con banda', 'muscle_group' => 'hombros', 'sets' => 3, 'reps' => '15', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Banda elástica o palo. Pasar por encima de la cabeza y detrás.', 'block_name' => 'Movilidad', 'order' => 0],
                            ['name' => 'Rotación externa de hombro con banda', 'muscle_group' => 'hombros', 'sets' => 3, 'reps' => '15 c/lado', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Codo a 90°, rotar hacia afuera. Fortalece manguito rotador.', 'block_name' => 'Movilidad', 'order' => 1],
                            ['name' => 'Estiramiento pectoral en puerta', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '30 seg c/lado', 'rest' => '15', 'rest_seconds' => 15, 'notes' => 'Brazo en marco de puerta a 90°. Avanzar hasta sentir estiramiento.', 'block_name' => 'Estiramiento', 'order' => 2],
                            ['name' => 'Cat-cow (gato-vaca)', 'muscle_group' => 'espalda', 'sets' => 3, 'reps' => '10', 'rest' => '20', 'rest_seconds' => 20, 'notes' => 'En cuatro puntos. Alternar extensión y flexión de columna.', 'block_name' => 'Movilidad Espinal', 'order' => 3],
                            ['name' => 'Thread the needle', 'muscle_group' => 'espalda', 'sets' => 3, 'reps' => '8 c/lado', 'rest' => '20', 'rest_seconds' => 20, 'notes' => 'Rotación torácica. Pasar brazo por debajo del cuerpo.', 'block_name' => 'Movilidad Espinal', 'order' => 4],
                            ['name' => 'Estiramiento de tríceps y dorsales', 'muscle_group' => 'tríceps', 'sets' => 2, 'reps' => '30 seg c/lado', 'rest' => '15', 'rest_seconds' => 15, 'notes' => 'Brazo detrás de la cabeza, empujar codo. Mantener posición.', 'block_name' => 'Estiramiento', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 2 - Tren Inferior',
                        'exercises' => [
                            ['name' => 'Sentadilla profunda con pausa', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '10', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Sin peso. Bajar lo más profundo posible, pausar 5 seg abajo.', 'block_name' => 'Movilidad', 'order' => 0],
                            ['name' => 'Estiramiento de isquiotibiales con banda', 'muscle_group' => 'isquiotibiales', 'sets' => 3, 'reps' => '30 seg c/pierna', 'rest' => '15', 'rest_seconds' => 15, 'notes' => 'Acostado, pierna recta arriba con banda. Sentir estiramiento.', 'block_name' => 'Flexibilidad', 'order' => 1],
                            ['name' => '90/90 stretch (cadera)', 'muscle_group' => 'glúteos', 'sets' => 3, 'reps' => '30 seg c/lado', 'rest' => '15', 'rest_seconds' => 15, 'notes' => 'Sentado, ambas piernas a 90°. Rotación interna y externa de cadera.', 'block_name' => 'Movilidad', 'order' => 2],
                            ['name' => 'Estiramiento de cuádriceps de pie', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '30 seg c/pierna', 'rest' => '15', 'rest_seconds' => 15, 'notes' => 'Talón al glúteo. Empujar cadera adelante para mayor estiramiento.', 'block_name' => 'Flexibilidad', 'order' => 3],
                            ['name' => 'Estiramiento de psoas (rodilla)', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '30 seg c/lado', 'rest' => '15', 'rest_seconds' => 15, 'notes' => 'Rodilla en el suelo, otra pierna al frente. Empujar cadera adelante.', 'block_name' => 'Flexibilidad', 'order' => 4],
                            ['name' => 'Foam rolling pantorrillas y femorales', 'muscle_group' => 'pantorrillas', 'sets' => 2, 'reps' => '60 seg c/pierna', 'rest' => '10', 'rest_seconds' => 10, 'notes' => 'Rodar lentamente, pausar en puntos dolorosos.', 'block_name' => 'Liberación Miofascial', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 3 - Full Body Flow',
                        'exercises' => [
                            ['name' => 'Sun salutation (saludo al sol)', 'muscle_group' => 'cuerpo_completo', 'sets' => 3, 'reps' => '5 ciclos', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Secuencia completa de yoga. Respiración guiada.', 'block_name' => 'Flow', 'order' => 0],
                            ['name' => 'World greatest stretch', 'muscle_group' => 'cuerpo_completo', 'sets' => 3, 'reps' => '5 c/lado', 'rest' => '20', 'rest_seconds' => 20, 'notes' => 'Zancada + rotación torácica + estiramiento de isquio. Todo en uno.', 'block_name' => 'Movilidad', 'order' => 1],
                            ['name' => 'Inchworms', 'muscle_group' => 'isquiotibiales', 'sets' => 3, 'reps' => '8', 'rest' => '20', 'rest_seconds' => 20, 'notes' => 'Caminar con manos al frente, luego pies hacia manos. Piernas rectas.', 'block_name' => 'Dinámico', 'order' => 2],
                            ['name' => 'Cossack squat (sentadilla cosaca)', 'muscle_group' => 'aductores', 'sets' => 3, 'reps' => '8 c/lado', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Sentadilla lateral profunda. Pie extendido recto.', 'block_name' => 'Movilidad', 'order' => 3],
                            ['name' => 'Scorpion stretch', 'muscle_group' => 'espalda', 'sets' => 2, 'reps' => '8 c/lado', 'rest' => '20', 'rest_seconds' => 20, 'notes' => 'Boca abajo, cruzar pierna por encima del cuerpo. Rotación espinal.', 'block_name' => 'Estiramiento', 'order' => 4],
                            ['name' => 'Respiración diafragmática', 'muscle_group' => 'abdominales', 'sets' => 1, 'reps' => '5 min', 'rest' => '0', 'rest_seconds' => 0, 'notes' => 'Acostado boca arriba. Inhalar 4 seg, mantener 4, exhalar 6. Relajar.', 'block_name' => 'Recuperación', 'order' => 5],
                        ],
                    ],
                ],
            ],

            // ============================================================
            // 12. FULL BODY AVANZADO - 4 DÍAS
            // ============================================================
            [
                'name' => 'Full Body Avanzado - 4 Días',
                'description' => 'Programa avanzado de 4 días full body con alta frecuencia muscular. Combina fuerza pesada con volumen moderado. Para atletas con más de 2 años de experiencia.',
                'type' => 'hipertrofia',
                'duration_weeks' => 10,
                'days' => [
                    [
                        'name' => 'Día 1 - Full Body (Fuerza Upper)',
                        'exercises' => [
                            ['name' => 'Press de banca con barra', 'muscle_group' => 'pecho', 'sets' => 5, 'reps' => '4-6', 'rest' => '180', 'rest_seconds' => 180, 'notes' => 'Pesado. RPE 8. Retracción escapular, arco controlado.', 'block_name' => 'Principal Upper', 'order' => 0],
                            ['name' => 'Remo con barra', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '6-8', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'Pesado. Espalda a 45°, tirar al ombligo.', 'block_name' => 'Principal Upper', 'order' => 1],
                            ['name' => 'Sentadilla con barra', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '8-10', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'Volumen moderado, peso al 70%.', 'block_name' => 'Lower', 'order' => 2],
                            ['name' => 'Elevaciones laterales', 'muscle_group' => 'hombros', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Peso ligero, repeticiones altas.', 'block_name' => 'Accesorio', 'order' => 3],
                            ['name' => 'Curl con barra', 'muscle_group' => 'bíceps', 'sets' => 2, 'reps' => '10-12', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Trabajo complementario de bíceps.', 'block_name' => 'Accesorio', 'order' => 4],
                            ['name' => 'Plancha abdominal', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '45 seg', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Core activo, posición perfecta.', 'block_name' => 'Core', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 2 - Full Body (Fuerza Lower)',
                        'exercises' => [
                            ['name' => 'Sentadilla con barra', 'muscle_group' => 'cuádriceps', 'sets' => 5, 'reps' => '4-6', 'rest' => '180', 'rest_seconds' => 180, 'notes' => 'Pesado. RPE 8. Profundidad completa.', 'block_name' => 'Principal Lower', 'order' => 0],
                            ['name' => 'Peso muerto rumano', 'muscle_group' => 'isquiotibiales', 'sets' => 4, 'reps' => '6-8', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'Pesado. Barra pegada a las piernas.', 'block_name' => 'Principal Lower', 'order' => 1],
                            ['name' => 'Press inclinado con mancuernas', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '10-12', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Volumen moderado para upper.', 'block_name' => 'Upper', 'order' => 2],
                            ['name' => 'Dominadas o jalón al pecho', 'muscle_group' => 'espalda', 'sets' => 3, 'reps' => '10-12', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Agarre prono, extensión completa.', 'block_name' => 'Upper', 'order' => 3],
                            ['name' => 'Hip thrust con barra', 'muscle_group' => 'glúteos', 'sets' => 3, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Apretar glúteos arriba.', 'block_name' => 'Accesorio', 'order' => 4],
                            ['name' => 'Elevaciones de pantorrillas', 'muscle_group' => 'pantorrillas', 'sets' => 4, 'reps' => '15-20', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Rango completo.', 'block_name' => 'Accesorio', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 3 - Full Body (Volumen Upper)',
                        'exercises' => [
                            ['name' => 'Press militar con barra', 'muscle_group' => 'hombros', 'sets' => 4, 'reps' => '8-10', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Volumen moderado. De pie, core activo.', 'block_name' => 'Principal Upper', 'order' => 0],
                            ['name' => 'Jalón al pecho agarre cerrado', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '10-12', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Agarre supino, énfasis en dorsales.', 'block_name' => 'Principal Upper', 'order' => 1],
                            ['name' => 'Sentadilla búlgara', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '10-12 c/pierna', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Con mancuernas. Control de equilibrio.', 'block_name' => 'Lower', 'order' => 2],
                            ['name' => 'Aperturas con mancuernas', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Arco amplio, peso ligero.', 'block_name' => 'Accesorio', 'order' => 3],
                            ['name' => 'Extensiones de tríceps en polea', 'muscle_group' => 'tríceps', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Cuerda, extensión completa.', 'block_name' => 'Accesorio', 'order' => 4],
                            ['name' => 'Crunch abdominal', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '15-20', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Elevar escápulas, squeeze arriba.', 'block_name' => 'Core', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 4 - Full Body (Volumen Lower)',
                        'exercises' => [
                            ['name' => 'Peso muerto convencional', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '5-6', 'rest' => '180', 'rest_seconds' => 180, 'notes' => 'Moderado-pesado. Forma perfecta.', 'block_name' => 'Principal Lower', 'order' => 0],
                            ['name' => 'Prensa de piernas', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '10-12', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Pies al ancho de hombros. Rango completo.', 'block_name' => 'Lower', 'order' => 1],
                            ['name' => 'Press de banca con mancuernas', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '10-12', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Mayor rango de movimiento que barra.', 'block_name' => 'Upper', 'order' => 2],
                            ['name' => 'Remo con mancuerna a una mano', 'muscle_group' => 'espalda', 'sets' => 3, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Un lado a la vez, control total.', 'block_name' => 'Upper', 'order' => 3],
                            ['name' => 'Curl de piernas acostado', 'muscle_group' => 'isquiotibiales', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Caderas pegadas al banco.', 'block_name' => 'Aislamiento', 'order' => 4],
                            ['name' => 'Face pulls', 'muscle_group' => 'hombros', 'sets' => 3, 'reps' => '15-20', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Salud de hombros. Rotación externa.', 'block_name' => 'Prehab', 'order' => 5],
                        ],
                    ],
                ],
            ],

            // ============================================================
            // 13. PECHO Y ESPALDA ESPECIALIZADO - 4 DÍAS
            // ============================================================
            [
                'name' => 'Pecho y Espalda Especializado - 4 Días',
                'description' => 'Programa de 4 días con énfasis en el desarrollo de pecho y espalda. Incluye trabajo complementario de hombros, brazos y piernas.',
                'type' => 'hipertrofia',
                'duration_weeks' => 8,
                'days' => [
                    [
                        'name' => 'Día 1 - Pecho (Volumen)',
                        'exercises' => [
                            ['name' => 'Press de banca con barra', 'muscle_group' => 'pecho', 'sets' => 5, 'reps' => '6-8', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'Compuesto pesado. Retracción escapular, arco moderado.', 'block_name' => 'Principal', 'order' => 0],
                            ['name' => 'Press inclinado con mancuernas', 'muscle_group' => 'pecho', 'sets' => 4, 'reps' => '10-12', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Banco 30°. Pecho superior.', 'block_name' => 'Principal', 'order' => 1],
                            ['name' => 'Cruces en polea alta', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Cruzar manos, apretar pecho 2 seg.', 'block_name' => 'Aislamiento', 'order' => 2],
                            ['name' => 'Aperturas con mancuernas', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Arco amplio, estiramiento profundo.', 'block_name' => 'Aislamiento', 'order' => 3],
                            ['name' => 'Fondos en paralelas', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '10-15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Inclinarse adelante para pecho. Finisher.', 'block_name' => 'Finisher', 'order' => 4],
                            ['name' => 'Extensiones de tríceps en polea', 'muscle_group' => 'tríceps', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Complemento para tríceps.', 'block_name' => 'Accesorio', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 2 - Espalda (Volumen)',
                        'exercises' => [
                            ['name' => 'Dominadas o jalón al pecho', 'muscle_group' => 'espalda', 'sets' => 5, 'reps' => '6-8', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'Agarre prono, peso añadido si posible.', 'block_name' => 'Principal', 'order' => 0],
                            ['name' => 'Remo con barra', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '8-10', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Torso a 45°, tirar al ombligo.', 'block_name' => 'Principal', 'order' => 1],
                            ['name' => 'Remo en polea baja sentado', 'muscle_group' => 'espalda', 'sets' => 3, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Agarre cerrado V. Squeeze escápulas.', 'block_name' => 'Accesorio', 'order' => 2],
                            ['name' => 'Pullover con mancuerna', 'muscle_group' => 'espalda', 'sets' => 3, 'reps' => '12-15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Estiramiento de dorsales. Brazos semi-extendidos.', 'block_name' => 'Accesorio', 'order' => 3],
                            ['name' => 'Encogimientos con mancuernas', 'muscle_group' => 'trapecios', 'sets' => 3, 'reps' => '15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Subir hombros a las orejas. Pausar arriba.', 'block_name' => 'Accesorio', 'order' => 4],
                            ['name' => 'Curl con barra', 'muscle_group' => 'bíceps', 'sets' => 3, 'reps' => '10-12', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Complemento de bíceps. Sin balanceo.', 'block_name' => 'Accesorio', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 3 - Piernas y Core',
                        'exercises' => [
                            ['name' => 'Sentadilla con barra', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '8-10', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'Profundidad paralela mínimo.', 'block_name' => 'Compuesto', 'order' => 0],
                            ['name' => 'Peso muerto rumano', 'muscle_group' => 'isquiotibiales', 'sets' => 3, 'reps' => '10-12', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Estiramiento isquios. Espalda neutra.', 'block_name' => 'Compuesto', 'order' => 1],
                            ['name' => 'Prensa de piernas', 'muscle_group' => 'cuádriceps', 'sets' => 3, 'reps' => '12-15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Pies altos para isquios/glúteos.', 'block_name' => 'Accesorio', 'order' => 2],
                            ['name' => 'Elevaciones de pantorrillas', 'muscle_group' => 'pantorrillas', 'sets' => 4, 'reps' => '15-20', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Rango completo, pausa arriba.', 'block_name' => 'Aislamiento', 'order' => 3],
                            ['name' => 'Plancha abdominal', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '60 seg', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Core fuerte, cuerpo en línea.', 'block_name' => 'Core', 'order' => 4],
                            ['name' => 'Elevación de piernas colgando', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Piernas rectas hasta 90°.', 'block_name' => 'Core', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 4 - Hombros y Brazos',
                        'exercises' => [
                            ['name' => 'Press Arnold', 'muscle_group' => 'hombros', 'sets' => 4, 'reps' => '8-10', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Rotación completa durante el press.', 'block_name' => 'Compuesto', 'order' => 0],
                            ['name' => 'Elevaciones laterales', 'muscle_group' => 'hombros', 'sets' => 4, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Peso ligero, tensión constante.', 'block_name' => 'Aislamiento', 'order' => 1],
                            ['name' => 'Face pulls', 'muscle_group' => 'hombros', 'sets' => 3, 'reps' => '15-20', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Polea alta, rotación externa.', 'block_name' => 'Posterior', 'order' => 2],
                            ['name' => 'Curl inclinado con mancuernas', 'muscle_group' => 'bíceps', 'sets' => 3, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Banco a 45°. Gran estiramiento en bíceps.', 'block_name' => 'Bíceps', 'order' => 3],
                            ['name' => 'Press francés con barra Z', 'muscle_group' => 'tríceps', 'sets' => 3, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Bajar detrás de la cabeza. Codos fijos.', 'block_name' => 'Tríceps', 'order' => 4],
                            ['name' => 'Curl martillo', 'muscle_group' => 'bíceps', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Agarre neutro. Braquiorradial.', 'block_name' => 'Bíceps', 'order' => 5],
                        ],
                    ],
                ],
            ],

            // ============================================================
            // 14. CIRCUITO METABÓLICO - 3 DÍAS
            // ============================================================
            [
                'name' => 'Circuito Metabólico - 3 Días',
                'description' => 'Programa de circuitos de alta intensidad que combina fuerza y cardio. Diseñado para maximizar el gasto calórico y mejorar la composición corporal.',
                'type' => 'hiit',
                'duration_weeks' => 6,
                'days' => [
                    [
                        'name' => 'Día 1 - Circuito A (Push + Core)',
                        'exercises' => [
                            ['name' => 'Press de banca con mancuernas', 'muscle_group' => 'pecho', 'sets' => 4, 'reps' => '12', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Sin descanso entre ejercicios del circuito. 60 seg al completar ronda.', 'block_name' => 'Circuito', 'order' => 0],
                            ['name' => 'Sentadilla con salto', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '15', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Explosión al saltar. Parte del circuito.', 'block_name' => 'Circuito', 'order' => 1],
                            ['name' => 'Press military con mancuernas', 'muscle_group' => 'hombros', 'sets' => 4, 'reps' => '12', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'De pie, control total. Parte del circuito.', 'block_name' => 'Circuito', 'order' => 2],
                            ['name' => 'Mountain climbers', 'muscle_group' => 'abdominales', 'sets' => 4, 'reps' => '30 seg', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Velocidad máxima. Parte del circuito.', 'block_name' => 'Circuito', 'order' => 3],
                            ['name' => 'Burpees', 'muscle_group' => 'cuerpo_completo', 'sets' => 4, 'reps' => '10', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Cierre de ronda. 60 seg de descanso antes de la siguiente ronda.', 'block_name' => 'Circuito', 'order' => 4],
                            ['name' => 'Plancha abdominal', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '45 seg', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'After-burn finisher. Core máximo.', 'block_name' => 'Finisher', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 2 - Circuito B (Pull + Cardio)',
                        'exercises' => [
                            ['name' => 'Remo con barra', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '12', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Peso moderado, ritmo constante.', 'block_name' => 'Circuito', 'order' => 0],
                            ['name' => 'Zancadas caminando', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '10 c/pierna', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Con mancuernas. Pasos largos y controlados.', 'block_name' => 'Circuito', 'order' => 1],
                            ['name' => 'Curl con mancuernas', 'muscle_group' => 'bíceps', 'sets' => 4, 'reps' => '12', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Alternando. Parte del circuito.', 'block_name' => 'Circuito', 'order' => 2],
                            ['name' => 'Jumping jacks', 'muscle_group' => 'cuerpo_completo', 'sets' => 4, 'reps' => '30 seg', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Cardio dentro del circuito.', 'block_name' => 'Circuito', 'order' => 3],
                            ['name' => 'Sentadilla con barra', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '10', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Cierra la ronda. Peso moderado. 60 seg descanso.', 'block_name' => 'Circuito', 'order' => 4],
                            ['name' => 'Elevación de piernas colgando', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '12', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Finisher de core. Piernas rectas si puedes.', 'block_name' => 'Finisher', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 3 - Circuito C (Full Body)',
                        'exercises' => [
                            ['name' => 'Peso muerto convencional', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '8', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Peso al 60%. Forma perfecta, ritmo fluido.', 'block_name' => 'Circuito', 'order' => 0],
                            ['name' => 'Flexiones de brazos', 'muscle_group' => 'pecho', 'sets' => 4, 'reps' => '15', 'rest' => '20', 'rest_seconds' => 20, 'notes' => 'Rápidas y controladas.', 'block_name' => 'Circuito', 'order' => 1],
                            ['name' => 'Hip thrust con barra', 'muscle_group' => 'glúteos', 'sets' => 4, 'reps' => '15', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Ritmo rápido, apretar arriba.', 'block_name' => 'Circuito', 'order' => 2],
                            ['name' => 'Dominadas o jalón al pecho', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '10', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Agarre prono. Completar sin pausa extra.', 'block_name' => 'Circuito', 'order' => 3],
                            ['name' => 'Box jumps', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '10', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Cierre explosivo de ronda. 60 seg descanso.', 'block_name' => 'Circuito', 'order' => 4],
                            ['name' => 'Crunch abdominal', 'muscle_group' => 'abdominales', 'sets' => 3, 'reps' => '25', 'rest' => '30', 'rest_seconds' => 30, 'notes' => 'Finisher. Quemar los abdominales.', 'block_name' => 'Finisher', 'order' => 5],
                        ],
                    ],
                ],
            ],

            // ============================================================
            // 15. BRAZOS Y HOMBROS -  3 DÍAS
            // ============================================================
            [
                'name' => 'Brazos y Hombros Especializado - 3 Días',
                'description' => 'Programa de especialización de 3 días para brazos y hombros con trabajo complementario de pecho/espalda/piernas. Para quienes quieren mejorar sus puntos débiles.',
                'type' => 'hipertrofia',
                'duration_weeks' => 6,
                'days' => [
                    [
                        'name' => 'Día 1 - Hombros + Piernas',
                        'exercises' => [
                            ['name' => 'Press militar con barra', 'muscle_group' => 'hombros', 'sets' => 4, 'reps' => '6-8', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'De pie. El press pesado es la base para hombros grandes.', 'block_name' => 'Principal', 'order' => 0],
                            ['name' => 'Elevaciones laterales', 'muscle_group' => 'hombros', 'sets' => 5, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Alto volumen para deltoides lateral. Clave de la anchura.', 'block_name' => 'Volumen', 'order' => 1],
                            ['name' => 'Face pulls', 'muscle_group' => 'hombros', 'sets' => 4, 'reps' => '15-20', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Deltoides posterior y rotación externa.', 'block_name' => 'Posterior', 'order' => 2],
                            ['name' => 'Elevaciones frontales', 'muscle_group' => 'hombros', 'sets' => 3, 'reps' => '12', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Alternando con mancuernas o disco.', 'block_name' => 'Anterior', 'order' => 3],
                            ['name' => 'Sentadilla con barra', 'muscle_group' => 'cuádriceps', 'sets' => 4, 'reps' => '8-10', 'rest' => '120', 'rest_seconds' => 120, 'notes' => 'Mantener piernas. No descuidar lower body.', 'block_name' => 'Piernas', 'order' => 4],
                            ['name' => 'Peso muerto rumano', 'muscle_group' => 'isquiotibiales', 'sets' => 3, 'reps' => '10-12', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Cadena posterior. Complemento de piernas.', 'block_name' => 'Piernas', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 2 - Bíceps + Pecho',
                        'exercises' => [
                            ['name' => 'Curl con barra', 'muscle_group' => 'bíceps', 'sets' => 4, 'reps' => '8-10', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Pesado pero sin balanceo. La base del bíceps.', 'block_name' => 'Principal', 'order' => 0],
                            ['name' => 'Curl inclinado con mancuernas', 'muscle_group' => 'bíceps', 'sets' => 3, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Banco a 45°. Máximo estiramiento de bíceps.', 'block_name' => 'Estiramiento', 'order' => 1],
                            ['name' => 'Curl martillo', 'muscle_group' => 'bíceps', 'sets' => 3, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Braquiorradial y bíceps largo.', 'block_name' => 'Variación', 'order' => 2],
                            ['name' => 'Curl de concentración', 'muscle_group' => 'bíceps', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Codo contra muslo. Aislamiento máximo.', 'block_name' => 'Aislamiento', 'order' => 3],
                            ['name' => 'Press de banca con barra', 'muscle_group' => 'pecho', 'sets' => 4, 'reps' => '8-10', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Mantener pecho. No descuidar.', 'block_name' => 'Pecho', 'order' => 4],
                            ['name' => 'Aperturas con mancuernas', 'muscle_group' => 'pecho', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Volumen complementario de pecho.', 'block_name' => 'Pecho', 'order' => 5],
                        ],
                    ],
                    [
                        'name' => 'Día 3 - Tríceps + Espalda',
                        'exercises' => [
                            ['name' => 'Press francés con barra Z', 'muscle_group' => 'tríceps', 'sets' => 4, 'reps' => '8-10', 'rest' => '75', 'rest_seconds' => 75, 'notes' => 'Estiramiento profundo del tríceps largo.', 'block_name' => 'Principal', 'order' => 0],
                            ['name' => 'Extensiones de tríceps en polea', 'muscle_group' => 'tríceps', 'sets' => 4, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Cuerda, extensión completa. Codos fijos.', 'block_name' => 'Volumen', 'order' => 1],
                            ['name' => 'Fondos en paralelas', 'muscle_group' => 'tríceps', 'sets' => 3, 'reps' => '10-15', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Cuerpo recto para tríceps. Con peso si es fácil.', 'block_name' => 'Compuesto', 'order' => 2],
                            ['name' => 'Kickbacks con mancuerna', 'muscle_group' => 'tríceps', 'sets' => 3, 'reps' => '12-15', 'rest' => '45', 'rest_seconds' => 45, 'notes' => 'Extensión completa detrás. Squeeze 1 seg.', 'block_name' => 'Aislamiento', 'order' => 3],
                            ['name' => 'Dominadas o jalón al pecho', 'muscle_group' => 'espalda', 'sets' => 4, 'reps' => '8-10', 'rest' => '90', 'rest_seconds' => 90, 'notes' => 'Mantener espalda. Agarre prono ancho.', 'block_name' => 'Espalda', 'order' => 4],
                            ['name' => 'Remo con mancuerna a una mano', 'muscle_group' => 'espalda', 'sets' => 3, 'reps' => '10-12', 'rest' => '60', 'rest_seconds' => 60, 'notes' => 'Volumen complementario de espalda.', 'block_name' => 'Espalda', 'order' => 5],
                        ],
                    ],
                ],
            ],
        ];

        $createdCount = 0;
        foreach ($templates as $template) {
            // Avoid duplicates by name
            if (Workout::where('name', $template['name'])->where('is_official', true)->exists()) {
                continue;
            }

            Workout::create(array_merge($template, [
                'user_id' => null,
                'client_id' => null,
                'is_active' => true,
                'is_official' => true,
            ]));
            $createdCount++;
        }

        $this->command->info("✅ {$createdCount} additional workout templates created successfully.");
    }

    private function seedMealPlanTemplates(): void
    {
        $foods = Food::whereNull('user_id')->where('is_active', true)->pluck('id', 'name');

        $getFoodId = function (string $name) use ($foods) {
            return $foods->get($name) ?? $foods->first(fn($id, $n) => str_contains(strtolower($n), strtolower($name)));
        };

        $plans = [
            // ============================================================
            // 6. CETOGÉNICA (KETO) - 1800 kcal
            // ============================================================
            [
                'name' => 'Dieta Cetogénica Keto - 1800 kcal',
                'description' => 'Plan cetogénico con menos de 30g de carbohidratos netos al día. Alto en grasas saludables y proteínas moderadas para entrar en cetosis.',
                'goal_type' => 'lose',
                'target_calories' => 1800,
                'target_proteins' => 130,
                'target_carbs' => 25,
                'target_fats' => 130,
                'meals' => [
                    ['meal_type' => 'breakfast', 'items' => [
                        ['name' => 'Huevo entero', 'qty' => 3],
                        ['name' => 'Aguacate', 'qty' => 0.5],
                        ['name' => 'Bacon/Tocino', 'qty' => 1],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                    ['meal_type' => 'lunch', 'items' => [
                        ['name' => 'Salmón', 'qty' => 1],
                        ['name' => 'Espinacas cocidas', 'qty' => 2],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                        ['name' => 'Almendras', 'qty' => 0.5],
                    ]],
                    ['meal_type' => 'mid_afternoon_snack', 'items' => [
                        ['name' => 'Queso Cheddar', 'qty' => 1],
                        ['name' => 'Nueces', 'qty' => 1],
                    ]],
                    ['meal_type' => 'dinner', 'items' => [
                        ['name' => 'Carne de Res magra', 'qty' => 1],
                        ['name' => 'Brócoli cocido', 'qty' => 2],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                ],
            ],

            // ============================================================
            // 7. DIETA MEDITERRÁNEA - 2000 kcal
            // ============================================================
            [
                'name' => 'Dieta Mediterránea - 2000 kcal',
                'description' => 'Plan basado en la dieta mediterránea: aceite de oliva, pescado, legumbres, frutas y verduras abundantes. Equilibrada y sostenible a largo plazo.',
                'goal_type' => 'maintain',
                'target_calories' => 2000,
                'target_proteins' => 120,
                'target_carbs' => 220,
                'target_fats' => 70,
                'meals' => [
                    ['meal_type' => 'breakfast', 'items' => [
                        ['name' => 'Avena', 'qty' => 1.5],
                        ['name' => 'Yogur Griego natural', 'qty' => 1],
                        ['name' => 'Miel', 'qty' => 0.5],
                        ['name' => 'Nueces', 'qty' => 0.5],
                    ]],
                    ['meal_type' => 'mid_morning_snack', 'items' => [
                        ['name' => 'Manzana', 'qty' => 1],
                        ['name' => 'Almendras', 'qty' => 0.5],
                    ]],
                    ['meal_type' => 'lunch', 'items' => [
                        ['name' => 'Tilapia', 'qty' => 1],
                        ['name' => 'Arroz integral', 'qty' => 1],
                        ['name' => 'Tomate', 'qty' => 1],
                        ['name' => 'Aceite de Oliva', 'qty' => 1.5],
                        ['name' => 'Espinacas frescas', 'qty' => 1],
                    ]],
                    ['meal_type' => 'mid_afternoon_snack', 'items' => [
                        ['name' => 'Hummus', 'qty' => 1],
                        ['name' => 'Zanahoria cruda', 'qty' => 1],
                    ]],
                    ['meal_type' => 'dinner', 'items' => [
                        ['name' => 'Pechuga de Pollo', 'qty' => 1],
                        ['name' => 'Lentejas cocidas', 'qty' => 1],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                        ['name' => 'Pimiento rojo', 'qty' => 0.5],
                    ]],
                ],
            ],

            // ============================================================
            // 8. AYUNO INTERMITENTE 16:8 - 2000 kcal
            // ============================================================
            [
                'name' => 'Ayuno Intermitente 16:8 - 2000 kcal',
                'description' => 'Plan diseñado para ventana de alimentación de 8 horas (12pm-8pm). 3 comidas concentradas con macros equilibrados.',
                'goal_type' => 'lose',
                'target_calories' => 2000,
                'target_proteins' => 150,
                'target_carbs' => 180,
                'target_fats' => 70,
                'meals' => [
                    ['meal_type' => 'lunch', 'items' => [
                        ['name' => 'Pechuga de Pollo', 'qty' => 1.5],
                        ['name' => 'Arroz blanco cocido', 'qty' => 1.5],
                        ['name' => 'Aguacate', 'qty' => 0.5],
                        ['name' => 'Brócoli cocido', 'qty' => 1],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                    ['meal_type' => 'mid_afternoon_snack', 'items' => [
                        ['name' => 'Proteína de Suero (Whey)', 'qty' => 1],
                        ['name' => 'Banana', 'qty' => 1],
                        ['name' => 'Mantequilla de Maní/Cacahuate', 'qty' => 1],
                        ['name' => 'Avena', 'qty' => 1],
                    ]],
                    ['meal_type' => 'dinner', 'items' => [
                        ['name' => 'Salmón', 'qty' => 1],
                        ['name' => 'Batata (Camote)', 'qty' => 1],
                        ['name' => 'Espinacas cocidas', 'qty' => 1.5],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                ],
            ],

            // ============================================================
            // 9. PLAN PARA ATLETAS - 2800 kcal
            // ============================================================
            [
                'name' => 'Plan para Atletas - 2800 kcal',
                'description' => 'Plan de alto rendimiento con carbohidratos elevados para deportistas activos. Comidas distribuidas alrededor de los entrenamientos.',
                'goal_type' => 'maintain',
                'target_calories' => 2800,
                'target_proteins' => 180,
                'target_carbs' => 350,
                'target_fats' => 75,
                'meals' => [
                    ['meal_type' => 'breakfast', 'items' => [
                        ['name' => 'Avena', 'qty' => 2],
                        ['name' => 'Banana', 'qty' => 1],
                        ['name' => 'Huevo entero', 'qty' => 3],
                        ['name' => 'Clara de Huevo', 'qty' => 2],
                        ['name' => 'Pan integral', 'qty' => 2],
                    ]],
                    ['meal_type' => 'mid_morning_snack', 'items' => [
                        ['name' => 'Arroz blanco cocido', 'qty' => 1],
                        ['name' => 'Pechuga de Pollo', 'qty' => 1],
                        ['name' => 'Manzana', 'qty' => 1],
                    ]],
                    ['meal_type' => 'lunch', 'items' => [
                        ['name' => 'Pechuga de Pollo', 'qty' => 1.5],
                        ['name' => 'Arroz blanco cocido', 'qty' => 2],
                        ['name' => 'Batata (Camote)', 'qty' => 1],
                        ['name' => 'Brócoli cocido', 'qty' => 1],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                    ['meal_type' => 'mid_afternoon_snack', 'items' => [
                        ['name' => 'Proteína de Suero (Whey)', 'qty' => 1],
                        ['name' => 'Banana', 'qty' => 1],
                        ['name' => 'Avena', 'qty' => 1],
                    ]],
                    ['meal_type' => 'dinner', 'items' => [
                        ['name' => 'Carne de Res magra', 'qty' => 1],
                        ['name' => 'Papa (Cocida)', 'qty' => 1.5],
                        ['name' => 'Espinacas cocidas', 'qty' => 1],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                    ['meal_type' => 'snack', 'items' => [
                        ['name' => 'Yogur Griego natural', 'qty' => 1],
                        ['name' => 'Almendras', 'qty' => 1],
                    ]],
                ],
            ],

            // ============================================================
            // 10. PLAN DIABÉTICO / BAJO ÍNDICE GLUCÉMICO - 1800 kcal
            // ============================================================
            [
                'name' => 'Bajo Índice Glucémico - 1800 kcal',
                'description' => 'Plan diseñado con alimentos de bajo índice glucémico. Ideal para control de azúcar en sangre, resistencia a la insulina o diabetes tipo 2.',
                'goal_type' => 'lose',
                'target_calories' => 1800,
                'target_proteins' => 140,
                'target_carbs' => 150,
                'target_fats' => 65,
                'meals' => [
                    ['meal_type' => 'breakfast', 'items' => [
                        ['name' => 'Avena', 'qty' => 1],
                        ['name' => 'Huevo entero', 'qty' => 2],
                        ['name' => 'Almendras', 'qty' => 0.5],
                        ['name' => 'Arándanos/Blueberries', 'qty' => 0.5],
                    ]],
                    ['meal_type' => 'mid_morning_snack', 'items' => [
                        ['name' => 'Yogur Griego 0%', 'qty' => 1],
                        ['name' => 'Nueces', 'qty' => 0.5],
                    ]],
                    ['meal_type' => 'lunch', 'items' => [
                        ['name' => 'Pechuga de Pollo', 'qty' => 1],
                        ['name' => 'Quinoa cocida', 'qty' => 1],
                        ['name' => 'Brócoli cocido', 'qty' => 1.5],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                    ['meal_type' => 'mid_afternoon_snack', 'items' => [
                        ['name' => 'Atún en lata (en agua)', 'qty' => 1],
                        ['name' => 'Pepino', 'qty' => 1],
                    ]],
                    ['meal_type' => 'dinner', 'items' => [
                        ['name' => 'Tilapia', 'qty' => 1],
                        ['name' => 'Lentejas cocidas', 'qty' => 1],
                        ['name' => 'Espinacas cocidas', 'qty' => 1],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                ],
            ],

            // ============================================================
            // 11. PREPARACIÓN DE COMPETENCIA - 1500 kcal
            // ============================================================
            [
                'name' => 'Preparación de Competencia - 1500 kcal',
                'description' => 'Plan restrictivo para las últimas semanas antes de una competencia de fitness/bodybuilding. Déficit agresivo con proteínas muy altas para preservar músculo.',
                'goal_type' => 'lose',
                'target_calories' => 1500,
                'target_proteins' => 180,
                'target_carbs' => 80,
                'target_fats' => 45,
                'meals' => [
                    ['meal_type' => 'breakfast', 'items' => [
                        ['name' => 'Clara de Huevo', 'qty' => 4],
                        ['name' => 'Avena', 'qty' => 0.5],
                        ['name' => 'Espinacas frescas', 'qty' => 1],
                    ]],
                    ['meal_type' => 'mid_morning_snack', 'items' => [
                        ['name' => 'Proteína de Suero (Whey)', 'qty' => 1],
                        ['name' => 'Pepino', 'qty' => 1],
                    ]],
                    ['meal_type' => 'lunch', 'items' => [
                        ['name' => 'Pechuga de Pollo', 'qty' => 1.5],
                        ['name' => 'Arroz integral', 'qty' => 0.5],
                        ['name' => 'Brócoli cocido', 'qty' => 2],
                        ['name' => 'Aceite de Oliva', 'qty' => 0.5],
                    ]],
                    ['meal_type' => 'mid_afternoon_snack', 'items' => [
                        ['name' => 'Atún en lata (en agua)', 'qty' => 1],
                        ['name' => 'Espinacas frescas', 'qty' => 1],
                    ]],
                    ['meal_type' => 'dinner', 'items' => [
                        ['name' => 'Tilapia', 'qty' => 1],
                        ['name' => 'Espárragos', 'qty' => 1.5],
                        ['name' => 'Aceite de Oliva', 'qty' => 0.5],
                    ]],
                ],
            ],

            // ============================================================
            // 12. VOLUMEN LIMPIO (LEAN BULK) - 2600 kcal
            // ============================================================
            [
                'name' => 'Volumen Limpio (Lean Bulk) - 2600 kcal',
                'description' => 'Plan de superávit calórico controlado para ganar masa muscular minimizando la ganancia de grasa. Comidas limpias con macros equilibrados.',
                'goal_type' => 'gain',
                'target_calories' => 2600,
                'target_proteins' => 180,
                'target_carbs' => 300,
                'target_fats' => 70,
                'meals' => [
                    ['meal_type' => 'breakfast', 'items' => [
                        ['name' => 'Avena', 'qty' => 2],
                        ['name' => 'Huevo entero', 'qty' => 3],
                        ['name' => 'Banana', 'qty' => 1],
                        ['name' => 'Mantequilla de Maní/Cacahuate', 'qty' => 1],
                    ]],
                    ['meal_type' => 'mid_morning_snack', 'items' => [
                        ['name' => 'Arroz blanco cocido', 'qty' => 1],
                        ['name' => 'Pechuga de Pollo', 'qty' => 1],
                    ]],
                    ['meal_type' => 'lunch', 'items' => [
                        ['name' => 'Carne de Res magra', 'qty' => 1],
                        ['name' => 'Arroz blanco cocido', 'qty' => 2],
                        ['name' => 'Brócoli cocido', 'qty' => 1],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                    ['meal_type' => 'mid_afternoon_snack', 'items' => [
                        ['name' => 'Proteína de Suero (Whey)', 'qty' => 1],
                        ['name' => 'Batata (Camote)', 'qty' => 1],
                    ]],
                    ['meal_type' => 'dinner', 'items' => [
                        ['name' => 'Salmón', 'qty' => 1],
                        ['name' => 'Papa (Cocida)', 'qty' => 1],
                        ['name' => 'Espinacas cocidas', 'qty' => 1],
                        ['name' => 'Aguacate', 'qty' => 0.3],
                    ]],
                    ['meal_type' => 'snack', 'items' => [
                        ['name' => 'Yogur Griego natural', 'qty' => 1],
                        ['name' => 'Avena', 'qty' => 0.5],
                        ['name' => 'Miel', 'qty' => 0.5],
                    ]],
                ],
            ],

            // ============================================================
            // 13. PLAN FAMILIAR EQUILIBRADO - 2000 kcal
            // ============================================================
            [
                'name' => 'Plan Familiar Equilibrado - 2000 kcal',
                'description' => 'Plan versátil que funciona para toda la familia. Comidas sencillas de preparar con ingredientes comunes y equilibrio nutricional completo.',
                'goal_type' => 'maintain',
                'target_calories' => 2000,
                'target_proteins' => 120,
                'target_carbs' => 250,
                'target_fats' => 60,
                'meals' => [
                    ['meal_type' => 'breakfast', 'items' => [
                        ['name' => 'Huevo entero', 'qty' => 2],
                        ['name' => 'Pan integral', 'qty' => 2],
                        ['name' => 'Banana', 'qty' => 1],
                        ['name' => 'Leche semidesnatada', 'qty' => 1],
                    ]],
                    ['meal_type' => 'mid_morning_snack', 'items' => [
                        ['name' => 'Manzana', 'qty' => 1],
                        ['name' => 'Yogur natural', 'qty' => 1],
                    ]],
                    ['meal_type' => 'lunch', 'items' => [
                        ['name' => 'Pechuga de Pollo', 'qty' => 1],
                        ['name' => 'Arroz blanco cocido', 'qty' => 1.5],
                        ['name' => 'Frijoles/Alubias negras', 'qty' => 1],
                        ['name' => 'Tomate', 'qty' => 0.5],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                    ['meal_type' => 'mid_afternoon_snack', 'items' => [
                        ['name' => 'Pan integral', 'qty' => 1],
                        ['name' => 'Queso Fresco/Burgos', 'qty' => 1],
                    ]],
                    ['meal_type' => 'dinner', 'items' => [
                        ['name' => 'Tilapia', 'qty' => 1],
                        ['name' => 'Papa (Cocida)', 'qty' => 1],
                        ['name' => 'Brócoli cocido', 'qty' => 1],
                        ['name' => 'Zanahoria cruda', 'qty' => 0.5],
                    ]],
                ],
            ],

            // ============================================================
            // 14. PLAN ANTI-INFLAMATORIO - 1900 kcal
            // ============================================================
            [
                'name' => 'Plan Anti-inflamatorio - 1900 kcal',
                'description' => 'Plan basado en alimentos con propiedades antiinflamatorias: omega-3, antioxidantes, especias y verduras crucíferas. Ideal para recuperación y salud general.',
                'goal_type' => 'maintain',
                'target_calories' => 1900,
                'target_proteins' => 130,
                'target_carbs' => 190,
                'target_fats' => 65,
                'meals' => [
                    ['meal_type' => 'breakfast', 'items' => [
                        ['name' => 'Avena', 'qty' => 1],
                        ['name' => 'Arándanos/Blueberries', 'qty' => 1],
                        ['name' => 'Nueces', 'qty' => 0.5],
                        ['name' => 'Semillas de Chía', 'qty' => 0.5],
                    ]],
                    ['meal_type' => 'mid_morning_snack', 'items' => [
                        ['name' => 'Piña', 'qty' => 1],
                        ['name' => 'Almendras', 'qty' => 0.5],
                    ]],
                    ['meal_type' => 'lunch', 'items' => [
                        ['name' => 'Salmón', 'qty' => 1],
                        ['name' => 'Quinoa cocida', 'qty' => 1],
                        ['name' => 'Kale/Col rizada', 'qty' => 1],
                        ['name' => 'Aceite de Oliva', 'qty' => 1.5],
                    ]],
                    ['meal_type' => 'mid_afternoon_snack', 'items' => [
                        ['name' => 'Yogur Griego natural', 'qty' => 1],
                        ['name' => 'Fresas', 'qty' => 0.5],
                    ]],
                    ['meal_type' => 'dinner', 'items' => [
                        ['name' => 'Pechuga de Pollo', 'qty' => 1],
                        ['name' => 'Batata (Camote)', 'qty' => 1],
                        ['name' => 'Brócoli cocido', 'qty' => 1.5],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                ],
            ],

            // ============================================================
            // 15. PLAN RICO EN FIBRA - 2100 kcal
            // ============================================================
            [
                'name' => 'Plan Rico en Fibra - 2100 kcal',
                'description' => 'Plan con alto contenido de fibra (35-40g/día) para mejorar la digestión, la saciedad y la salud intestinal. Legumbres, granos integrales y muchas verduras.',
                'goal_type' => 'maintain',
                'target_calories' => 2100,
                'target_proteins' => 130,
                'target_carbs' => 260,
                'target_fats' => 55,
                'meals' => [
                    ['meal_type' => 'breakfast', 'items' => [
                        ['name' => 'Avena', 'qty' => 2],
                        ['name' => 'Semillas de Chía', 'qty' => 0.5],
                        ['name' => 'Manzana', 'qty' => 1],
                        ['name' => 'Semillas de Lino/Linaza', 'qty' => 0.5],
                    ]],
                    ['meal_type' => 'mid_morning_snack', 'items' => [
                        ['name' => 'Pera', 'qty' => 1],
                        ['name' => 'Almendras', 'qty' => 0.5],
                    ]],
                    ['meal_type' => 'lunch', 'items' => [
                        ['name' => 'Pechuga de Pollo', 'qty' => 1],
                        ['name' => 'Arroz integral', 'qty' => 1.5],
                        ['name' => 'Lentejas cocidas', 'qty' => 1],
                        ['name' => 'Brócoli cocido', 'qty' => 1],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                    ['meal_type' => 'mid_afternoon_snack', 'items' => [
                        ['name' => 'Hummus', 'qty' => 1],
                        ['name' => 'Zanahoria cruda', 'qty' => 1],
                        ['name' => 'Pan integral', 'qty' => 1],
                    ]],
                    ['meal_type' => 'dinner', 'items' => [
                        ['name' => 'Tilapia', 'qty' => 1],
                        ['name' => 'Garbanzos cocidos', 'qty' => 1],
                        ['name' => 'Espinacas cocidas', 'qty' => 1.5],
                        ['name' => 'Aceite de Oliva', 'qty' => 1],
                    ]],
                ],
            ],
        ];

        $createdCount = 0;
        foreach ($plans as $plan) {
            // Avoid duplicates by name
            if (MealPlan::where('name', $plan['name'])->where('is_official', true)->exists()) {
                continue;
            }

            $this->createMealPlan(
                $plan['name'],
                $plan['description'],
                $plan['goal_type'],
                $plan['target_calories'],
                $plan['target_proteins'],
                $plan['target_carbs'],
                $plan['target_fats'],
                $plan['meals'],
                $getFoodId
            );
            $createdCount++;
        }

        $this->command->info("✅ {$createdCount} additional meal plan templates created successfully.");
    }

    private function createMealPlan(
        string $name,
        string $description,
        string $goalType,
        int $calories,
        int $proteins,
        int $carbs,
        int $fats,
        array $meals,
        \Closure $getFoodId
    ): void {
        DB::beginTransaction();

        try {
            $mealPlan = MealPlan::create([
                'user_id' => null,
                'client_id' => null,
                'name' => $name,
                'description' => $description,
                'goal_type' => $goalType,
                'target_calories' => $calories,
                'target_proteins' => $proteins,
                'target_carbs' => $carbs,
                'target_fats' => $fats,
                'is_active' => true,
                'is_official' => true,
            ]);

            $order = 0;
            foreach ($meals as $meal) {
                foreach ($meal['items'] as $item) {
                    $foodId = $getFoodId($item['name']);
                    if (!$foodId) {
                        continue; // Skip if food not found
                    }

                    $food = Food::find($foodId);
                    if (!$food) continue;

                    $servingWeight = $food->serving_weight ?: 100;
                    $grams = $item['qty'] * $servingWeight;

                    MealItem::create([
                        'meal_plan_id' => $mealPlan->id,
                        'food_id' => $food->id,
                        'meal_type' => $meal['meal_type'],
                        'quantity' => $grams,
                        'proteins' => round(($food->proteins / ($servingWeight / 100)) * ($grams / 100), 2),
                        'carbs' => round(($food->carbs / ($servingWeight / 100)) * ($grams / 100), 2),
                        'fats' => round(($food->fats / ($servingWeight / 100)) * ($grams / 100), 2),
                        'calories' => round(($food->calories / ($servingWeight / 100)) * ($grams / 100), 2),
                        'order' => $order++,
                    ]);
                }
            }

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            $this->command->error("Error creating meal plan '{$name}': " . $e->getMessage());
        }
    }
}
