<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_fee_settings', function (Blueprint $table) {
            $table->id();
            $table->string('gateway')->unique(); // 'paypal', 'stripe'
            $table->decimal('percentage', 5, 2)->default(0); // e.g., 3.49 for PayPal
            $table->decimal('fixed_amount', 10, 2)->default(0); // e.g., 0.49 for PayPal
            $table->boolean('is_active')->default(true);
            $table->boolean('pass_to_customer')->default(false); // If true, add fee to total; if false, coach absorbs
            $table->timestamps();
        });

        // Seed with official rates
        DB::table('payment_fee_settings')->insert([
            [
                'gateway' => 'paypal',
                'percentage' => 3.49,
                'fixed_amount' => 0.49,
                'is_active' => true,
                'pass_to_customer' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'gateway' => 'stripe',
                'percentage' => 2.90,
                'fixed_amount' => 0.30,
                'is_active' => true,
                'pass_to_customer' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_fee_settings');
    }
};
