<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            // Track when notifications were sent to avoid duplicate notifications
            $table->timestamp('expiring_notified_at')->nullable()->after('cancellation_reason');
            $table->timestamp('expired_notified_at')->nullable()->after('expiring_notified_at');
            $table->timestamp('fully_deactivated_at')->nullable()->after('expired_notified_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->dropColumn(['expiring_notified_at', 'expired_notified_at', 'fully_deactivated_at']);
        });
    }
};
