<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('landing_settings', function (Blueprint $table) {
            $table->id();
            $table->string('section')->index(); // hero, benefits, testimonials, cta, footer, colors, etc.
            $table->string('key');
            $table->longText('value')->nullable();
            $table->boolean('is_published')->default(true);
            $table->timestamps();

            $table->unique(['section', 'key']);
        });

        Schema::create('landing_testimonials', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('role')->nullable(); // "Coach de fitness", "Atleta", etc.
            $table->text('content');
            $table->string('avatar')->nullable();
            $table->integer('rating')->default(5);
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        Schema::create('landing_features', function (Blueprint $table) {
            $table->id();
            $table->string('icon')->default('star'); // Icon name
            $table->string('title');
            $table->text('description');
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        Schema::create('landing_stats', function (Blueprint $table) {
            $table->id();
            $table->string('label'); // "Coaches Activos", "Clientes Satisfechos"
            $table->string('value'); // "500+", "10K+"
            $table->string('icon')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        Schema::create('social_links', function (Blueprint $table) {
            $table->id();
            $table->string('platform'); // facebook, instagram, tiktok, youtube, twitter
            $table->string('url');
            $table->string('icon')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('social_links');
        Schema::dropIfExists('landing_stats');
        Schema::dropIfExists('landing_features');
        Schema::dropIfExists('landing_testimonials');
        Schema::dropIfExists('landing_settings');
    }
};
