<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // Precio en Pesos Dominicanos
            $table->decimal('price_dop', 10, 2)->nullable()->after('price');
            $table->decimal('compare_price_dop', 10, 2)->nullable()->after('compare_price');
            
            // Campos para suplementos
            $table->json('sizes')->nullable()->after('dimensions'); // Ej: ["900g", "2kg", "5lb"]
            $table->json('flavors')->nullable()->after('sizes'); // Ej: ["Chocolate", "Vainilla", "Fresa"]
            
            // Campo para información nutricional
            $table->json('nutrition_info')->nullable()->after('flavors'); // Info nutricional
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn([
                'price_dop',
                'compare_price_dop',
                'sizes',
                'flavors',
                'nutrition_info',
            ]);
        });
    }
};
