<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Change ENUM to VARCHAR to support all payment method types
        Schema::table('coach_plan_purchases', function (Blueprint $table) {
            $table->string('payment_method', 50)->default('other')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Convert back to ENUM (data may be lost if values don't match)
        DB::statement("ALTER TABLE coach_plan_purchases MODIFY payment_method ENUM('paypal', 'paypal_me', 'transfer', 'cash', 'other') DEFAULT 'paypal'");
    }
};
