<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('coach_plans', function (Blueprint $table) {
            // Pricing tiers section
            $table->json('pricing_tiers')->nullable()->after('nav_links');
            $table->string('pricing_title')->nullable()->after('pricing_tiers');
            $table->string('pricing_subtitle')->nullable()->after('pricing_title');
            $table->text('pricing_guarantee_text')->nullable()->after('pricing_subtitle');
            
            // Results/Transformations section customization
            $table->string('results_title')->nullable()->after('pricing_guarantee_text');
            $table->string('results_subtitle')->nullable()->after('results_title');
            
            // FAQ section customization
            $table->string('faq_title')->nullable()->after('results_subtitle');
            $table->string('faq_subtitle')->nullable()->after('faq_title');
            
            // Final CTA section
            $table->string('final_cta_title')->nullable()->after('faq_subtitle');
            $table->text('final_cta_subtitle')->nullable()->after('final_cta_title');
            $table->string('final_cta_button_text')->nullable()->after('final_cta_subtitle');
            
            // Currency settings
            $table->string('currency', 10)->default('USD')->after('price');
            $table->string('currency_symbol', 5)->default('$')->after('currency');
            
            // Draft/Published status for autosave
            $table->json('draft_data')->nullable()->after('final_cta_button_text');
            $table->timestamp('last_autosave_at')->nullable()->after('draft_data');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('coach_plans', function (Blueprint $table) {
            $table->dropColumn([
                'pricing_tiers',
                'pricing_title',
                'pricing_subtitle',
                'pricing_guarantee_text',
                'results_title',
                'results_subtitle',
                'faq_title',
                'faq_subtitle',
                'final_cta_title',
                'final_cta_subtitle',
                'final_cta_button_text',
                'currency',
                'currency_symbol',
                'draft_data',
                'last_autosave_at',
            ]);
        });
    }
};
