<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('coach_plans', function (Blueprint $table) {
            $table->string('hero_title')->nullable()->after('description');
            $table->string('hero_subtitle')->nullable()->after('hero_title');
            $table->string('hero_image')->nullable()->after('hero_subtitle');
            $table->json('target_points')->nullable()->after('features');
            $table->json('faqs')->nullable()->after('target_points');
            $table->string('badge')->nullable()->after('faqs');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('coach_plans', function (Blueprint $table) {
            $table->dropColumn([
                'hero_title',
                'hero_subtitle', 
                'hero_image',
                'target_points',
                'faqs',
                'badge'
            ]);
        });
    }
};
