<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('foods', function (Blueprint $table) {
            $table->string('serving_size')->nullable()->after('category'); // ej: "1 taza", "100g"
            $table->decimal('serving_weight', 8, 2)->nullable()->after('serving_size'); // Peso en gramos
            $table->string('meal_type')->nullable()->after('serving_weight'); // tipo de comida
            $table->boolean('is_active')->default(true)->after('is_custom');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('foods', function (Blueprint $table) {
            $table->dropColumn(['serving_size', 'serving_weight', 'meal_type', 'is_active']);
        });
    }
};
