<?php

namespace App\Notifications;

use App\Models\LandingTestimonial;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TestimonialApproved extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public LandingTestimonial $testimonial
    ) {}

    public function via(object $notifiable): array
    {
        // Database first to ensure in-app notification is saved even if mail fails
        return ['database', 'mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('¡Tu testimonio ha sido aprobado! 🎉')
            ->greeting("¡Hola {$notifiable->name}!")
            ->line('Nos complace informarte que tu testimonio ha sido aprobado y ahora es visible en nuestra página principal.')
            ->line('Gracias por compartir tu experiencia con la comunidad de CoachPro.')
            ->line('Tu testimonio:')
            ->line("\"{$this->testimonial->content}\"")
            ->action('Ver Landing Page', url('/'))
            ->line('¡Gracias por ser parte de nuestra comunidad!');
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'testimonial_approved',
            'testimonial_id' => $this->testimonial->id,
            'message' => '¡Tu testimonio ha sido aprobado y publicado!',
        ];
    }
}
