<?php

namespace App\Notifications;

use App\Models\CoachPlanPurchase;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class CoachPlanSuspended extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public CoachPlanPurchase $purchase,
        public ?string $reason = null
    ) {}

    public function via($notifiable): array
    {
        // Database first to ensure in-app notification is saved even if mail fails
        return ['database', 'mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        $plan = $this->purchase->coachPlan;

        $message = (new MailMessage)
            ->subject('Tu plan ha sido suspendido - ' . $plan->name)
            ->greeting('Hola ' . $this->purchase->buyer_name)
            ->line('Tu acceso al plan **' . $plan->name . '** ha sido temporalmente suspendido.');

        if ($this->reason) {
            $message->line('**Motivo:** ' . $this->reason);
        }

        return $message
            ->line('Si tienes pagos pendientes, por favor regulariza tu situación para reactivar tu acceso.')
            ->line('Si crees que esto es un error, contacta a tu coach.')
            ->action('Contactar a mi coach', url('/client/messages'))
            ->line('Estamos aquí para ayudarte.');
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'coach_plan_suspended',
            'purchase_id' => $this->purchase->id,
            'plan_id' => $this->purchase->coach_plan_id,
            'plan_name' => $this->purchase->coachPlan->name,
            'reason' => $this->reason,
            'message' => 'Tu plan ' . $this->purchase->coachPlan->name . ' ha sido suspendido.',
        ];
    }
}
