<?php

namespace App\Notifications;

use App\Models\CoachPlanPurchase;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class CoachPlanPurchaseCancelled extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public CoachPlanPurchase $purchase,
        public ?string $reason = null
    ) {}

    public function via($notifiable): array
    {
        // Database first to ensure in-app notification is saved even if mail fails
        return ['database', 'mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        $plan = $this->purchase->coachPlan;

        $message = (new MailMessage)
            ->subject('Compra cancelada - ' . $plan->name)
            ->greeting('Hola ' . $this->purchase->buyer_name)
            ->line('Lamentamos informarte que tu compra ha sido cancelada.')
            ->line('**Plan:** ' . $plan->name)
            ->line('**Monto:** $' . number_format($this->purchase->amount, 2));

        if ($this->reason) {
            $message->line('**Motivo:** ' . $this->reason);
        }

        return $message
            ->line('Si crees que esto es un error o tienes alguna pregunta, por favor contacta al coach.')
            ->action('Contactar soporte', url('/contact'));
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'coach_plan_cancelled',
            'purchase_id' => $this->purchase->id,
            'plan_id' => $this->purchase->coach_plan_id,
            'plan_name' => $this->purchase->coachPlan->name,
            'reason' => $this->reason,
            'message' => 'Tu compra del plan ' . $this->purchase->coachPlan->name . ' ha sido cancelada.',
        ];
    }
}
