<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PhotoLike extends Model
{
    protected $fillable = [
        'progress_photo_id',
        'ip_address',
    ];

    public $timestamps = false;

    protected $casts = [
        'created_at' => 'datetime',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->created_at = now();
        });
    }

    public function photo(): BelongsTo
    {
        return $this->belongsTo(ProgressPhoto::class, 'progress_photo_id');
    }
}
