<?php

namespace App\Http\Controllers;

use App\Models\DynamicPage;
use Inertia\Inertia;
use Inertia\Response;

class DynamicPageController extends Controller
{
    /**
     * Display the specified dynamic page.
     */
    public function show(string $slug): Response
    {
        $page = DynamicPage::where('slug', $slug)
            ->where('is_active', true)
            ->firstOrFail();

        return Inertia::render('Pages/Dynamic', [
            'page' => [
                'title' => $page->title,
                'slug' => $page->slug,
                'content' => $page->content,
                'meta_title' => $page->meta_title,
                'meta_description' => $page->meta_description,
            ],
        ]);
    }
}
