<?php

namespace App\Http\Controllers\Coach;

use App\Http\Controllers\Controller;
use App\Models\Faq;
use App\Models\Setting;
use Illuminate\Http\Request;
use Inertia\Inertia;

/**
 * Controller for coach support functionality
 */
class SupportController extends Controller
{
    /**
     * Display the support page with FAQ and contact form
     */
    public function index()
    {
        return Inertia::render('Coach/Support/Index', [
            'faqs' => Faq::active()->ordered()->get(['id', 'question', 'answer']),
            'supportEmail' => Setting::get('support_email', 'soporte@coachpro.com'),
        ]);
    }

    /**
     * Submit a support ticket
     */
    public function send(Request $request)
    {
        $request->validate([
            'subject' => 'required|string|max:255',
            'category' => 'required|string|in:technical,billing,account,feature,other',
            'message' => 'required|string|max:5000',
            'priority' => 'required|string|in:low,normal,high',
        ]);

        // Here you would typically:
        // 1. Send email to support team
        // 2. Create a support ticket in database
        // 3. Send confirmation to user
        
        // For now, we'll just flash a success message
        // In production, implement proper ticket system

        return redirect()->route('coach.support.index')
            ->with('success', 'Tu mensaje ha sido enviado correctamente. Te responderemos en un plazo de 24-48 horas.');
    }
}
