<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use App\Http\Traits\ChatTrait;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Inertia\Response;

class ChatController extends Controller
{
    use ChatTrait;

    public function index(Request $request): Response
    {
        $clientUser = $request->user();
        $clientProfile = $clientUser->clientProfile;

        if (!$clientProfile) {
            abort(403);
        }

        $coach = $clientProfile->user; // The coach User model

        // Mark messages as read and get conversation using trait
        $this->markMessagesAsRead($coach->id, $clientUser->id);
        $messages = $this->getConversation($clientUser->id, $coach->id);

        return Inertia::render('Client/Chat/Index', [
            'coach' => [
                'id' => $coach->id,
                'name' => $coach->name,
                'avatar' => $coach->avatar
                    ? (str_starts_with($coach->avatar, 'http') || str_starts_with($coach->avatar, '/storage/')
                        ? $coach->avatar
                        : '/storage/' . $coach->avatar)
                    : null,
            ],
            'messages' => $messages,
        ]);
    }

    public function store(Request $request): RedirectResponse
    {
        $request->validate([
            'content' => 'required|string|max:1000',
        ]);

        $clientUser = $request->user();
        $coach = $clientUser->clientProfile->user;

        $this->createAndNotifyMessage($clientUser, $coach->id, $request->content);

        return back();
    }
}

