<?php

namespace App\Console\Commands;

use App\Models\Subscription;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class UpdateExpiredSubscriptions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'subscriptions:update-expired';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update subscription statuses for expired subscriptions';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        // Find active subscriptions that have passed their end_date
        $expiredCount = Subscription::where('status', 'active')
            ->whereDate('end_date', '<', now())
            ->update([
                'status' => 'expired',
                'expired_notified_at' => now(),
            ]);

        $this->info("Updated {$expiredCount} expired subscription(s).");
        Log::info("Subscriptions: Updated {$expiredCount} expired subscriptions");

        return Command::SUCCESS;
    }
}
